/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import org.apache.hive.service.cli.thrift.TTypeId;

public enum Type {
    BOOLEAN_TYPE("BOOLEAN", 16, TTypeId.BOOLEAN_TYPE),
    TINYINT_TYPE("TINYINT", -6, TTypeId.TINYINT_TYPE),
    SMALLINT_TYPE("SMALLINT", 5, TTypeId.SMALLINT_TYPE),
    INT_TYPE("INT", 4, TTypeId.INT_TYPE),
    BIGINT_TYPE("BIGINT", -5, TTypeId.BIGINT_TYPE),
    FLOAT_TYPE("FLOAT", 6, TTypeId.FLOAT_TYPE),
    DOUBLE_TYPE("DOUBLE", 8, TTypeId.DOUBLE_TYPE),
    STRING_TYPE("STRING", 12, TTypeId.STRING_TYPE),
    TIMESTAMP_TYPE("TIMESTAMP", 93, TTypeId.TIMESTAMP_TYPE),
    BINARY_TYPE("BINARY", -2, TTypeId.BINARY_TYPE),
    DECIMAL_TYPE("DECIMAL", 3, TTypeId.DECIMAL_TYPE, false, false),
    ARRAY_TYPE("ARRAY", 12, TTypeId.STRING_TYPE, true, true),
    MAP_TYPE("MAP", 12, TTypeId.STRING_TYPE, true, true),
    STRUCT_TYPE("STRUCT", 12, TTypeId.STRING_TYPE, true, false),
    UNION_TYPE("UNIONTYPE", 12, TTypeId.STRING_TYPE, true, false),
    USER_DEFINED_TYPE(null, 12, TTypeId.STRING_TYPE, true, false);

    private final String name;
    private final TTypeId tType;
    private final int javaSQLType;
    private final boolean isComplex;
    private final boolean isCollection;

    private Type(String name, int javaSQLType, TTypeId tType, boolean isComplex, boolean isCollection) {
        this.name = name;
        this.javaSQLType = javaSQLType;
        this.tType = tType;
        this.isComplex = isComplex;
        this.isCollection = isCollection;
    }

    private Type(String name, int javaSqlType, TTypeId tType) {
        this(name, javaSqlType, tType, false, false);
    }

    public boolean isPrimitiveType() {
        return !this.isComplex;
    }

    public boolean isComplexType() {
        return this.isComplex;
    }

    public boolean isCollectionType() {
        return this.isCollection;
    }

    public static Type getType(TTypeId tType) {
        for (Type type : Type.values()) {
            if (!tType.equals((Object)type.tType)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unregonized Thrift TTypeId value: " + (Object)((Object)tType));
    }

    public static Type getType(String name) {
        for (Type type : Type.values()) {
            if (name.equalsIgnoreCase(type.name)) {
                return type;
            }
            if (!type.isComplexType() || !name.toUpperCase().startsWith(type.name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unrecognized type name: " + name);
    }

    public Integer getNumPrecRadix() {
        switch (this) {
            case TINYINT_TYPE: 
            case SMALLINT_TYPE: 
            case INT_TYPE: 
            case BIGINT_TYPE: {
                return 10;
            }
            case FLOAT_TYPE: 
            case DOUBLE_TYPE: {
                return 2;
            }
        }
        return null;
    }

    public Integer getDecimalDigits() {
        switch (this) {
            case TINYINT_TYPE: 
            case SMALLINT_TYPE: 
            case INT_TYPE: 
            case BIGINT_TYPE: 
            case BOOLEAN_TYPE: {
                return 0;
            }
            case FLOAT_TYPE: {
                return 7;
            }
            case DOUBLE_TYPE: {
                return 15;
            }
        }
        return null;
    }

    public Integer getPrecision() {
        switch (this) {
            case TINYINT_TYPE: {
                return 3;
            }
            case SMALLINT_TYPE: {
                return 5;
            }
            case INT_TYPE: {
                return 10;
            }
            case BIGINT_TYPE: {
                return 19;
            }
            case FLOAT_TYPE: {
                return 7;
            }
            case DOUBLE_TYPE: {
                return 15;
            }
        }
        return null;
    }

    public Integer getScale() {
        switch (this) {
            case TINYINT_TYPE: 
            case SMALLINT_TYPE: 
            case INT_TYPE: 
            case BIGINT_TYPE: 
            case BOOLEAN_TYPE: 
            case STRING_TYPE: 
            case TIMESTAMP_TYPE: {
                return 0;
            }
            case FLOAT_TYPE: {
                return 7;
            }
            case DOUBLE_TYPE: {
                return 15;
            }
            case DECIMAL_TYPE: {
                return Integer.MAX_VALUE;
            }
        }
        return null;
    }

    public Integer getColumnSize() {
        if (this.isNumericType()) {
            return this.getPrecision();
        }
        switch (this) {
            case STRING_TYPE: 
            case BINARY_TYPE: {
                return Integer.MAX_VALUE;
            }
            case TIMESTAMP_TYPE: {
                return 30;
            }
        }
        return null;
    }

    public boolean isNumericType() {
        switch (this) {
            case TINYINT_TYPE: 
            case SMALLINT_TYPE: 
            case INT_TYPE: 
            case BIGINT_TYPE: 
            case FLOAT_TYPE: 
            case DOUBLE_TYPE: 
            case DECIMAL_TYPE: {
                return true;
            }
        }
        return false;
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public Short getNullable() {
        return (short)1;
    }

    public Boolean isCaseSensitive() {
        switch (this) {
            case STRING_TYPE: {
                return true;
            }
        }
        return false;
    }

    public String getCreateParams() {
        return null;
    }

    public Short getSearchable() {
        if (this.isPrimitiveType()) {
            return (short)3;
        }
        return (short)0;
    }

    public Boolean isUnsignedAttribute() {
        if (this.isNumericType()) {
            return false;
        }
        return true;
    }

    public Boolean isFixedPrecScale() {
        return false;
    }

    public Boolean isAutoIncrement() {
        return false;
    }

    public String getLocalizedName() {
        return null;
    }

    public Short getMinimumScale() {
        return (short)0;
    }

    public Short getMaximumScale() {
        return (short)0;
    }

    public TTypeId toTType() {
        return this.tType;
    }

    public int toJavaSQLType() {
        return this.javaSQLType;
    }

    public String getName() {
        return this.name;
    }
}

