/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.service.cli.Row;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.thrift.TRow;
import org.apache.hive.service.cli.thrift.TRowSet;

public class RowSet {
    private long startOffset = 0L;
    private boolean hasMoreResults = false;
    private List<Row> rows = new ArrayList<Row>();

    public RowSet() {
    }

    public RowSet(TRowSet tRowSet) {
        this();
        this.startOffset = tRowSet.getStartRowOffset();
        for (TRow tRow : tRowSet.getRows()) {
            this.rows.add(new Row(tRow));
        }
    }

    public RowSet(List<Row> rows, long startOffset) {
        this();
        this.rows.addAll(rows);
        this.startOffset = startOffset;
    }

    public RowSet addRow(Row row) {
        this.rows.add(row);
        return this;
    }

    public RowSet addRow(TableSchema schema, Object[] fields) {
        return this.addRow(new Row(schema, fields));
    }

    public RowSet extractSubset(int maxRows) {
        int numRows = this.rows.size();
        maxRows = maxRows <= numRows ? maxRows : numRows;
        RowSet result = new RowSet(this.rows.subList(0, maxRows), this.startOffset);
        this.rows = new ArrayList<Row>(this.rows.subList(maxRows, numRows));
        this.startOffset += (long)result.getSize();
        return result;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public RowSet setStartOffset(long startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    public boolean getHasMoreResults() {
        return this.hasMoreResults;
    }

    public RowSet setHasMoreResults(boolean hasMoreResults) {
        this.hasMoreResults = hasMoreResults;
        return this;
    }

    public int getSize() {
        return this.rows.size();
    }

    public TRowSet toTRowSet() {
        TRowSet tRowSet = new TRowSet();
        tRowSet.setStartRowOffset(this.startOffset);
        ArrayList<TRow> tRows = new ArrayList<TRow>();
        for (Row row : this.rows) {
            tRows.add(row.toTRow());
        }
        tRowSet.setRows(tRows);
        return tRowSet;
    }
}

