/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsConstant;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTablesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.LogDivertAppender;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.operation.SQLOperationDisplay;
import org.apache.hive.service.cli.operation.SQLOperationDisplayCache;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class OperationManager
extends AbstractService {
    private final Log LOG = LogFactory.getLog((String)OperationManager.class.getName());
    private final ConcurrentHashMap<OperationHandle, Operation> handleToOperation = new ConcurrentHashMap();
    private Object webuiLock = new Object();
    private SQLOperationDisplayCache historicSqlOperations;
    private Map<String, SQLOperationDisplay> liveSqlOperations = new LinkedHashMap<String, SQLOperationDisplay>();

    public OperationManager() {
        super(OperationManager.class.getSimpleName());
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            this.initOperationLogCapture(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL));
        } else {
            this.LOG.debug((Object)"Operation level logging is turned off");
        }
        if (hiveConf.isWebUiQueryInfoCacheEnabled()) {
            this.historicSqlOperations = new SQLOperationDisplayCache(hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_MAX_HISTORIC_QUERIES));
        }
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    private void initOperationLogCapture(String loggingMode) {
        LogDivertAppender ap = new LogDivertAppender(this, OperationLog.getLoggingLevel((String)loggingMode));
        Logger.getRootLogger().addAppender((Appender)ap);
    }

    public ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync, long queryTimeout) throws HiveSQLException {
        ExecuteStatementOperation executeStatementOperation = ExecuteStatementOperation.newExecuteStatementOperation(parentSession, statement, confOverlay, runAsync, queryTimeout);
        this.addOperation(executeStatementOperation);
        return executeStatementOperation;
    }

    public GetTypeInfoOperation newGetTypeInfoOperation(HiveSession parentSession) {
        GetTypeInfoOperation operation = new GetTypeInfoOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetCatalogsOperation newGetCatalogsOperation(HiveSession parentSession) {
        GetCatalogsOperation operation = new GetCatalogsOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetSchemasOperation newGetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) {
        GetSchemasOperation operation = new GetSchemasOperation(parentSession, catalogName, schemaName);
        this.addOperation(operation);
        return operation;
    }

    public MetadataOperation newGetTablesOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        GetTablesOperation operation = new GetTablesOperation(parentSession, catalogName, schemaName, tableName, tableTypes);
        this.addOperation(operation);
        return operation;
    }

    public GetTableTypesOperation newGetTableTypesOperation(HiveSession parentSession) {
        GetTableTypesOperation operation = new GetTableTypesOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetColumnsOperation newGetColumnsOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        GetColumnsOperation operation = new GetColumnsOperation(parentSession, catalogName, schemaName, tableName, columnName);
        this.addOperation(operation);
        return operation;
    }

    public GetFunctionsOperation newGetFunctionsOperation(HiveSession parentSession, String catalogName, String schemaName, String functionName) {
        GetFunctionsOperation operation = new GetFunctionsOperation(parentSession, catalogName, schemaName, functionName);
        this.addOperation(operation);
        return operation;
    }

    public Operation getOperation(OperationHandle operationHandle) throws HiveSQLException {
        Operation operation = this.getOperationInternal(operationHandle);
        if (operation == null) {
            throw new HiveSQLException("Invalid OperationHandle: " + operationHandle);
        }
        return operation;
    }

    private Operation getOperationInternal(OperationHandle operationHandle) {
        return this.handleToOperation.get(operationHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperation(Operation operation) {
        this.LOG.info((Object)("Adding operation: " + operation.getHandle()));
        this.handleToOperation.put(operation.getHandle(), operation);
        if (operation instanceof SQLOperation) {
            Object object = this.webuiLock;
            synchronized (object) {
                this.liveSqlOperations.put(operation.getHandle().getHandleIdentifier().toString(), ((SQLOperation)operation).getSQLOperationDisplay());
            }
        }
    }

    private Operation removeOperation(OperationHandle opHandle) {
        Operation operation = this.handleToOperation.remove(opHandle);
        if (operation instanceof SQLOperation) {
            this.removeSaveSqlOperationDisplay(opHandle);
        }
        return operation;
    }

    private Operation removeTimedOutOperation(OperationHandle operationHandle) {
        Operation operation = this.handleToOperation.get(operationHandle);
        if (operation != null && operation.isTimedOut(System.currentTimeMillis())) {
            this.LOG.info((Object)("Operation is timed out,operation=" + operation.getHandle() + ",state=" + operation.getState().toString()));
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                try {
                    metrics.decrementCounter(MetricsConstant.OPEN_OPERATIONS);
                }
                catch (Exception e) {
                    this.LOG.warn((Object)"Error decrementing open_operations metric, reported values may be incorrect", (Throwable)e);
                }
            }
            this.handleToOperation.remove(operationHandle, operation);
            if (operation instanceof SQLOperation) {
                this.removeSaveSqlOperationDisplay(operationHandle);
            }
            return operation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSaveSqlOperationDisplay(OperationHandle operationHandle) {
        Object object = this.webuiLock;
        synchronized (object) {
            String opKey = operationHandle.getHandleIdentifier().toString();
            SQLOperationDisplay display = this.liveSqlOperations.remove(opKey);
            if (display == null) {
                this.LOG.debug((Object)("Unexpected display object value of null for operation " + opKey));
            } else if (this.historicSqlOperations != null) {
                this.historicSqlOperations.put(opKey, display);
            }
        }
    }

    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getStatus();
    }

    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.getOperation(opHandle);
        OperationState opState = operation.getStatus().getState();
        if (opState.isTerminal()) {
            this.LOG.debug((Object)(opHandle + ": Operation is already aborted in state - " + (Object)((Object)opState)));
        } else {
            this.LOG.debug((Object)(opHandle + ": Attempting to cancel from state - " + (Object)((Object)opState)));
            operation.cancel(OperationState.CANCELED);
        }
    }

    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.LOG.info((Object)("Closing operation: " + opHandle));
        Operation operation = this.removeOperation(opHandle);
        if (operation == null) {
            throw new HiveSQLException("Operation does not exist: " + opHandle);
        }
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                metrics.decrementCounter(MetricsConstant.OPEN_OPERATIONS);
            }
            catch (Exception e) {
                this.LOG.warn((Object)"Error Reporting close operation to Metrics system", (Throwable)e);
            }
        }
        operation.close();
    }

    public TableSchema getOperationResultSetSchema(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getResultSetSchema();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet(orientation, maxRows);
    }

    public RowSet getOperationLogRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows, HiveConf hConf) throws HiveSQLException {
        List logs;
        TableSchema tableSchema = new TableSchema(this.getLogSchema());
        RowSet rowSet = RowSetFactory.create(tableSchema, this.getOperation(opHandle).getProtocolVersion());
        if (!hConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            this.LOG.warn((Object)"Try to get operation log when hive.server2.logging.operation.enabled is false, no log will be returned. ");
            return rowSet;
        }
        OperationLog operationLog = this.getOperation(opHandle).getOperationLog();
        if (operationLog == null) {
            throw new HiveSQLException("Couldn't find log associated with operation handle: " + opHandle);
        }
        try {
            logs = operationLog.readOperationLog(this.isFetchFirst(orientation), maxRows);
        }
        catch (SQLException e) {
            throw new HiveSQLException(e.getMessage(), e.getCause());
        }
        for (String log : logs) {
            rowSet.addRow(new String[]{log});
        }
        return rowSet;
    }

    private boolean isFetchFirst(FetchOrientation fetchOrientation) {
        return fetchOrientation.equals((Object)FetchOrientation.FETCH_FIRST);
    }

    private Schema getLogSchema() {
        Schema schema = new Schema();
        FieldSchema fieldSchema = new FieldSchema();
        fieldSchema.setName("operation_log");
        fieldSchema.setType("string");
        schema.addToFieldSchemas(fieldSchema);
        return schema;
    }

    public Collection<Operation> getOperations() {
        return Collections.unmodifiableCollection(this.handleToOperation.values());
    }

    public OperationLog getOperationLogByThread() {
        return OperationLog.getCurrentOperationLog();
    }

    public List<Operation> removeExpiredOperations(OperationHandle[] handles) {
        ArrayList<Operation> removed = new ArrayList<Operation>();
        for (OperationHandle handle : handles) {
            Operation operation = this.removeTimedOutOperation(handle);
            if (operation == null) continue;
            this.LOG.warn((Object)("Operation " + handle + " is timed-out and will be closed"));
            removed.add(operation);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLOperationDisplay> getHistoricalSQLOperations() {
        LinkedList<SQLOperationDisplay> result = new LinkedList<SQLOperationDisplay>();
        Object object = this.webuiLock;
        synchronized (object) {
            if (this.historicSqlOperations != null) {
                result.addAll(this.historicSqlOperations.values());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SQLOperationDisplay> getLiveSqlOperations() {
        LinkedList<SQLOperationDisplay> result = new LinkedList<SQLOperationDisplay>();
        Object object = this.webuiLock;
        synchronized (object) {
            result.addAll(this.liveSqlOperations.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLOperationDisplay getSQLOperationDisplay(String handle) {
        Object object = this.webuiLock;
        synchronized (object) {
            if (this.historicSqlOperations == null) {
                return null;
            }
            SQLOperationDisplay result = this.liveSqlOperations.get(handle);
            if (result != null) {
                return result;
            }
            return (SQLOperationDisplay)this.historicSqlOperations.get(handle);
        }
    }
}

