/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import com.google.common.base.Strings;
import java.util.List;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.apache.hive.service.auth.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomQueryFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(HiveConf conf) {
        String customQuery = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY);
        if (Strings.isNullOrEmpty((String)customQuery)) {
            return null;
        }
        return new CustomQueryFilter(customQuery);
    }

    private static final class CustomQueryFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(CustomQueryFilter.class);
        private final String query;

        public CustomQueryFilter(String query) {
            this.query = query;
        }

        @Override
        public void apply(DirSearch client, String user) throws AuthenticationException {
            List<String> resultList;
            try {
                resultList = client.executeCustomQuery(this.query);
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
            if (resultList != null) {
                for (String matchedDn : resultList) {
                    String shortUserName = LdapUtils.getShortName(matchedDn);
                    LOG.info("<queried user=" + shortUserName + ",user=" + user + ">");
                    if (!shortUserName.equalsIgnoreCase(user) && !matchedDn.equalsIgnoreCase(user)) continue;
                    LOG.info("Authentication succeeded based on result set from LDAP query");
                    return;
                }
            }
            LOG.info("Authentication failed based on result set from custom LDAP query");
            throw new AuthenticationException("Authentication failed: LDAP query from property returned no data");
        }
    }
}

