/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl;

import java.util.Locale;
import org.apache.http.HttpResponse;
import org.talend.http.HttpResponseFactory;
import org.talend.http.ProtocolVersion;
import org.talend.http.ReasonPhraseCatalog;
import org.talend.http.StatusLine;
import org.talend.http.annotation.Immutable;
import org.talend.http.impl.EnglishReasonPhraseCatalog;
import org.talend.http.message.BasicHttpResponse;
import org.talend.http.message.BasicStatusLine;
import org.talend.http.protocol.HttpContext;
import org.talend.http.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

