/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.talend.http.HttpException;
import org.talend.http.HttpHost;
import org.talend.http.HttpRequest;
import org.talend.http.annotation.ThreadSafe;
import org.talend.http.client.ClientProtocolException;
import org.talend.http.client.config.RequestConfig;
import org.talend.http.client.methods.CloseableHttpResponse;
import org.talend.http.client.methods.Configurable;
import org.talend.http.client.methods.HttpExecutionAware;
import org.talend.http.client.methods.HttpRequestWrapper;
import org.talend.http.client.protocol.HttpClientContext;
import org.talend.http.conn.ClientConnectionManager;
import org.talend.http.conn.ClientConnectionRequest;
import org.talend.http.conn.HttpClientConnectionManager;
import org.talend.http.conn.ManagedClientConnection;
import org.talend.http.conn.routing.HttpRoute;
import org.talend.http.conn.scheme.SchemeRegistry;
import org.talend.http.impl.DefaultConnectionReuseStrategy;
import org.talend.http.impl.client.CloseableHttpClient;
import org.talend.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.talend.http.impl.execchain.MinimalClientExec;
import org.talend.http.params.BasicHttpParams;
import org.talend.http.params.HttpParams;
import org.talend.http.protocol.BasicHttpContext;
import org.talend.http.protocol.HttpContext;
import org.talend.http.protocol.HttpRequestExecutor;
import org.talend.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

