/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.conn;

import java.net.InetAddress;
import org.talend.http.HttpException;
import org.talend.http.HttpHost;
import org.talend.http.HttpRequest;
import org.talend.http.ProtocolException;
import org.talend.http.annotation.Immutable;
import org.talend.http.client.config.RequestConfig;
import org.talend.http.client.protocol.HttpClientContext;
import org.talend.http.conn.SchemePortResolver;
import org.talend.http.conn.UnsupportedSchemeException;
import org.talend.http.conn.routing.HttpRoute;
import org.talend.http.conn.routing.HttpRoutePlanner;
import org.talend.http.impl.conn.DefaultSchemePortResolver;
import org.talend.http.protocol.HttpContext;
import org.talend.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

