/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.conn;

import org.talend.http.HttpHost;
import org.talend.http.annotation.Immutable;
import org.talend.http.conn.SchemePortResolver;
import org.talend.http.conn.UnsupportedSchemeException;
import org.talend.http.util.Args;

@Immutable
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

