/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.cookie;

import java.util.Date;
import org.talend.http.annotation.Immutable;
import org.talend.http.client.utils.DateUtils;
import org.talend.http.cookie.CommonCookieAttributeHandler;
import org.talend.http.cookie.MalformedCookieException;
import org.talend.http.cookie.SetCookie;
import org.talend.http.impl.cookie.AbstractCookieAttributeHandler;
import org.talend.http.util.Args;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

