/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.cookie;

import java.util.Date;
import org.talend.http.annotation.Immutable;
import org.talend.http.cookie.CommonCookieAttributeHandler;
import org.talend.http.cookie.MalformedCookieException;
import org.talend.http.cookie.SetCookie;
import org.talend.http.impl.cookie.AbstractCookieAttributeHandler;
import org.talend.http.util.Args;

@Immutable
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

