/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.cookie;

import org.talend.http.annotation.Immutable;
import org.talend.http.cookie.CommonCookieAttributeHandler;
import org.talend.http.cookie.Cookie;
import org.talend.http.cookie.CookieOrigin;
import org.talend.http.cookie.MalformedCookieException;
import org.talend.http.cookie.SetCookie;
import org.talend.http.impl.cookie.AbstractCookieAttributeHandler;
import org.talend.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

