/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.cookie;

import org.talend.http.annotation.Immutable;
import org.talend.http.cookie.CommonCookieAttributeHandler;
import org.talend.http.cookie.Cookie;
import org.talend.http.cookie.CookieOrigin;
import org.talend.http.cookie.CookieRestrictionViolationException;
import org.talend.http.cookie.MalformedCookieException;
import org.talend.http.cookie.SetCookie;
import org.talend.http.impl.cookie.AbstractCookieAttributeHandler;
import org.talend.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

