/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.io;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.talend.http.HttpException;
import org.talend.http.HttpResponseFactory;
import org.talend.http.NoHttpResponseException;
import org.talend.http.ParseException;
import org.talend.http.StatusLine;
import org.talend.http.annotation.NotThreadSafe;
import org.talend.http.config.MessageConstraints;
import org.talend.http.impl.DefaultHttpResponseFactory;
import org.talend.http.impl.io.AbstractMessageParser;
import org.talend.http.io.SessionInputBuffer;
import org.talend.http.message.LineParser;
import org.talend.http.message.ParserCursor;
import org.talend.http.params.HttpParams;
import org.talend.http.util.Args;
import org.talend.http.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

