/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.io;

import org.apache.http.HttpResponse;
import org.talend.http.HttpResponseFactory;
import org.talend.http.annotation.Immutable;
import org.talend.http.config.MessageConstraints;
import org.talend.http.impl.DefaultHttpResponseFactory;
import org.talend.http.impl.io.DefaultHttpResponseParser;
import org.talend.http.io.HttpMessageParser;
import org.talend.http.io.HttpMessageParserFactory;
import org.talend.http.io.SessionInputBuffer;
import org.talend.http.message.BasicLineParser;
import org.talend.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

