/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.talend.http.HttpClientConnection;
import org.talend.http.HttpHost;
import org.talend.http.annotation.ThreadSafe;
import org.talend.http.config.ConnectionConfig;
import org.talend.http.config.SocketConfig;
import org.talend.http.impl.pool.BasicConnFactory;
import org.talend.http.impl.pool.BasicPoolEntry;
import org.talend.http.params.HttpParams;
import org.talend.http.pool.AbstractConnPool;
import org.talend.http.pool.ConnFactory;

@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

