/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.protocol;

import java.io.IOException;
import org.talend.http.HttpException;
import org.talend.http.HttpRequest;
import org.talend.http.HttpRequestInterceptor;
import org.talend.http.annotation.Immutable;
import org.talend.http.protocol.HttpContext;
import org.talend.http.util.Args;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

