/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.protocol;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.talend.http.HttpEntityEnclosingRequest;
import org.talend.http.HttpException;
import org.talend.http.HttpRequest;
import org.talend.http.HttpRequestInterceptor;
import org.talend.http.HttpVersion;
import org.talend.http.ProtocolVersion;
import org.talend.http.annotation.Immutable;
import org.talend.http.protocol.HttpContext;
import org.talend.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

