/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.protocol;

import java.io.IOException;
import org.talend.http.HttpException;
import org.talend.http.HttpRequest;
import org.talend.http.HttpRequestInterceptor;
import org.talend.http.annotation.Immutable;
import org.talend.http.params.HttpParams;
import org.talend.http.protocol.HttpContext;
import org.talend.http.util.Args;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

