/*
 * Decompiled with CFR 0.152.
 */
package org.talend.http.protocol;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.talend.http.HttpException;
import org.talend.http.HttpResponseInterceptor;
import org.talend.http.annotation.Immutable;
import org.talend.http.protocol.HttpContext;
import org.talend.http.util.Args;

@Immutable
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

