/*
 * Decompiled with CFR 0.152.
 */
package com.talend.net.minidev.json.reader;

import com.talend.net.minidev.json.JSONAware;
import com.talend.net.minidev.json.JSONAwareEx;
import com.talend.net.minidev.json.JSONObject;
import com.talend.net.minidev.json.JSONStreamAwareEx;
import com.talend.net.minidev.json.JSONStyle;
import com.talend.net.minidev.json.JSONUtil;
import com.talend.net.minidev.json.JSONValue;
import com.talend.net.minidev.json.reader.JsonWriterI;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minidev.asm.Accessor;
import net.minidev.asm.BeansAccess;
import net.minidev.asm.FieldFilter;

public class JsonWriter {
    private HashMap<Class<?>, JsonWriterI<?>> data = new HashMap();
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            value.writeJSONString(out);
        }
    };
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareExWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            value.writeJSONString(out, compression);
        }
    };
    public static final JsonWriterI<JSONAwareEx> JSONJSONAwareExWriter = new JsonWriterI<JSONAwareEx>(){

        @Override
        public <E extends JSONAwareEx> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            out.append(value.toJSONString(compression));
        }
    };
    public static final JsonWriterI<JSONAware> JSONJSONAwareWriter = new JsonWriterI<JSONAware>(){

        @Override
        public <E extends JSONAware> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            out.append(value.toJSONString());
        }
    };
    public static final JsonWriterI<Iterable<? extends Object>> JSONIterableWriter = new JsonWriterI<Iterable<? extends Object>>(){

        @Override
        public <E extends Iterable<? extends Object>> void writeJSONString(E list, Appendable out, JSONStyle compression) throws IOException {
            boolean first = true;
            compression.arrayStart(out);
            for (Object value : list) {
                if (first) {
                    first = false;
                    compression.arrayfirstObject(out);
                } else {
                    compression.arrayNextElm(out);
                }
                if (value == null) {
                    out.append("null");
                } else {
                    JSONValue.writeJSONString(value, out, compression);
                }
                compression.arrayObjectEnd(out);
            }
            compression.arrayStop(out);
        }
    };
    public static final JsonWriterI<Enum<?>> EnumWriter = new JsonWriterI<Enum<?>>(){

        @Override
        public <E extends Enum<?>> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            String s = value.name();
            compression.writeString(out, s);
        }
    };
    public static final JsonWriterI<Map<String, ? extends Object>> JSONMapWriter = new JsonWriterI<Map<String, ? extends Object>>(){

        @Override
        public <E extends Map<String, ? extends Object>> void writeJSONString(E map, Appendable out, JSONStyle compression) throws IOException {
            boolean first = true;
            compression.objectStart(out);
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                Object v = entry.getValue();
                if (v == null && compression.ignoreNull()) continue;
                if (first) {
                    compression.objectFirstStart(out);
                    first = false;
                } else {
                    compression.objectNext(out);
                }
                JsonWriter.writeJSONKV(entry.getKey().toString(), v, out, compression);
            }
            compression.objectStop(out);
        }
    };
    public static final JsonWriterI<Object> beansWriterASM = new JsonWriterI<Object>(){

        @Override
        public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            Class<?> cls = value.getClass();
            boolean needSep = false;
            BeansAccess fields = BeansAccess.get(cls, (FieldFilter)JSONUtil.JSON_SMART_FIELD_FILTER);
            out.append('{');
            for (Accessor field : fields.getAccessors()) {
                Object v = fields.get(value, field.getIndex());
                if (v == null && compression.ignoreNull()) continue;
                if (needSep) {
                    out.append(',');
                } else {
                    needSep = true;
                }
                JSONObject.writeJSONKV(field.getName(), v, out, compression);
            }
            out.append('}');
        }
    };
    public static final JsonWriterI<Object> beansWriter = new JsonWriterI<Object>(){

        @Override
        public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            try {
                boolean needSep = false;
                compression.objectStart(out);
                for (Class<?> nextClass = value.getClass(); nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = nextClass.getDeclaredFields()) {
                        int m = field.getModifiers();
                        if ((m & 0x98) > 0) continue;
                        Object v = null;
                        if ((m & 1) > 0) {
                            v = field.get(value);
                        } else {
                            Class<?> c2;
                            String g = JSONUtil.getGetterName(field.getName());
                            Method mtd = null;
                            try {
                                mtd = nextClass.getDeclaredMethod(g, new Class[0]);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (mtd == null && ((c2 = field.getType()) == Boolean.TYPE || c2 == Boolean.class)) {
                                g = JSONUtil.getIsName(field.getName());
                                mtd = nextClass.getDeclaredMethod(g, new Class[0]);
                            }
                            if (mtd == null) continue;
                            v = mtd.invoke(value, new Object[0]);
                        }
                        if (v == null && compression.ignoreNull()) continue;
                        if (needSep) {
                            compression.objectNext(out);
                        } else {
                            needSep = true;
                        }
                        JsonWriter.writeJSONKV(field.getName(), v, out, compression);
                    }
                }
                compression.objectStop(out);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final JsonWriterI<Object> arrayWriter = new JsonWriterI<Object>(){

        @Override
        public <E> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            compression.arrayStart(out);
            boolean needSep = false;
            for (Object o : (Object[])value) {
                if (needSep) {
                    compression.objectNext(out);
                } else {
                    needSep = true;
                }
                JSONValue.writeJSONString(o, out, compression);
            }
            compression.arrayStop(out);
        }
    };

    public JsonWriter() {
        this.init();
    }

    public JsonWriterI getWrite(Class cls) {
        return this.data.get(cls);
    }

    public void init() {
        this.registerWriter(new JsonWriterI<String>(){

            @Override
            public void writeJSONString(String value, Appendable out, JSONStyle compression) throws IOException {
                compression.writeString(out, value);
            }
        }, String.class);
        this.registerWriter(new JsonWriterI<Boolean>(){

            @Override
            public void writeJSONString(Boolean value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Boolean.class);
        this.registerWriter(new JsonWriterI<Double>(){

            @Override
            public void writeJSONString(Double value, Appendable out, JSONStyle compression) throws IOException {
                if (value.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            }
        }, Double.class);
        this.registerWriter(new JsonWriterI<Date>(){

            @Override
            public void writeJSONString(Date value, Appendable out, JSONStyle compression) throws IOException {
                out.append('\"');
                JSONValue.escape(value.toString(), out, compression);
                out.append('\"');
            }
        }, Date.class);
        this.registerWriter(new JsonWriterI<Float>(){

            @Override
            public void writeJSONString(Float value, Appendable out, JSONStyle compression) throws IOException {
                if (value.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value.toString());
                }
            }
        }, Float.class);
        this.registerWriter(new JsonWriterI<Number>(){

            @Override
            public void writeJSONString(Number value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Integer.class, Long.class, Byte.class, Short.class, BigInteger.class);
        this.registerWriter(new JsonWriterI<Boolean>(){

            @Override
            public void writeJSONString(Boolean value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Boolean.class);
        this.registerWriter(new JsonWriterI<Boolean>(){

            @Override
            public void writeJSONString(Boolean value, Appendable out, JSONStyle compression) throws IOException {
                out.append(value.toString());
            }
        }, Boolean.class);
        this.registerWriter(new JsonWriterI<int[]>(){

            @Override
            public void writeJSONString(int[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (int b : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Integer.toString(b));
                }
                compression.arrayStop(out);
            }
        }, int[].class);
        this.registerWriter(new JsonWriterI<short[]>(){

            @Override
            public void writeJSONString(short[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (short b : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Short.toString(b));
                }
                compression.arrayStop(out);
            }
        }, short[].class);
        this.registerWriter(new JsonWriterI<long[]>(){

            @Override
            public void writeJSONString(long[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (long b : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Long.toString(b));
                }
                compression.arrayStop(out);
            }
        }, long[].class);
        this.registerWriter(new JsonWriterI<float[]>(){

            @Override
            public void writeJSONString(float[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (float b : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Float.toString(b));
                }
                compression.arrayStop(out);
            }
        }, float[].class);
        this.registerWriter(new JsonWriterI<double[]>(){

            @Override
            public void writeJSONString(double[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (double b : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Double.toString(b));
                }
                compression.arrayStop(out);
            }
        }, double[].class);
        this.registerWriter(new JsonWriterI<boolean[]>(){

            @Override
            public void writeJSONString(boolean[] value, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (boolean b : value) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Boolean.toString(b));
                }
                compression.arrayStop(out);
            }
        }, boolean[].class);
    }

    public <T> void registerWriter(JsonWriterI<T> writer, Class<?> ... cls) {
        for (Class<?> c : cls) {
            this.data.put(c, writer);
        }
    }

    public static void writeJSONKV(String key, Object value, Appendable out, JSONStyle compression) throws IOException {
        if (key == null) {
            out.append("null");
        } else if (!compression.mustProtectKey(key)) {
            out.append(key);
        } else {
            out.append('\"');
            JSONValue.escape(key, out, compression);
            out.append('\"');
        }
        compression.objectEndOfKey(out);
        if (value instanceof String) {
            compression.writeString(out, (String)value);
        } else {
            JSONValue.writeJSONString(value, out, compression);
        }
        compression.objectElmStop(out);
    }
}

