/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.talend.net.minidev.json.JSONArray;
import com.talend.net.minidev.json.JSONObject;
import com.talend.net.minidev.json.JSONStyle;
import com.talend.net.minidev.json.JSONValue;
import com.talend.net.minidev.json.parser.JSONParser;
import com.talend.net.minidev.json.parser.ParseException;
import com.talend.net.minidev.json.writer.JsonReaderI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private final int parseMode;
    private final JsonReaderI<?> mapper;

    public JsonSmartJsonProvider() {
        this(-1, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int parseMode) {
        this(parseMode, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int parseMode, JsonReaderI<?> mapper) {
        this.parseMode = parseMode;
        this.mapper = mapper;
    }

    @Override
    public Object createArray() {
        return this.mapper.createArray();
    }

    @Override
    public Object createMap() {
        return this.mapper.createObject();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.createParser().parse(json, this.mapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.createParser().parse((Reader)new InputStreamReader(jsonStream, charset), this.mapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof Map) {
            return JSONObject.toJSONString((Map)obj, JSONStyle.LT_COMPRESS);
        }
        if (obj instanceof List) {
            return JSONArray.toJSONString((List)obj, JSONStyle.LT_COMPRESS);
        }
        throw new UnsupportedOperationException(obj.getClass().getName() + " can not be converted to JSON");
    }

    private JSONParser createParser() {
        return new JSONParser(this.parseMode);
    }
}

