/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.bind.DatatypeConverter;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Crc32;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CoreUtils$
implements Logging {
    public static final CoreUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new CoreUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        CoreUtils$ coreUtils$ = this;
        synchronized (coreUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Runnable runnable(Function0<BoxedUnit> fun) {
        return new Runnable(fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        };
    }

    public Thread newThread(String name, boolean daemon, Function0<BoxedUnit> fun) {
        return Utils.newThread((String)name, (Runnable)this.runnable(fun), (boolean)daemon);
    }

    public void swallow(Function2<Object, Throwable, BoxedUnit> log, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            log.apply((Object)throwable.getMessage(), (Object)throwable);
        }
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils.delete((File)new File(f));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerMBean(Object mbean, String name) {
        try {
            Boolean bl2;
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                bl2 = BoxesRunTime.boxToBoolean((boolean)true);
            }
            boolean bl = BoxesRunTime.unboxToBoolean((Object)bl2);
            return bl;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to register Mbean ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            }, (Function0<Throwable>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            return false;
        }
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            BoxedUnit boxedUnit;
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public long crc32(byte[] bytes) {
        return this.crc32(bytes, 0, bytes.length);
    }

    public long crc32(byte[] bytes, int offset, int size2) {
        Crc32 crc = new Crc32();
        crc.update(bytes, offset, size2);
        return crc.getValue();
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n;
        int n2 = channel.read(buffer);
        if (-1 == n2) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        int n3 = n = n2;
        return n3;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Tuple2[] keyVals = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String s) {
                int lio = s.lastIndexOf(":");
                return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return Predef$.MODULE$.refArrayOps((Object[])keyVals).toMap(Predef$.MODULE$.conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String v) {
                return !v.equals("");
            }
        }));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className, true, Utils.getContextOrKafkaClassLoader());
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(Object x$1) {
                return x$1.getClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        return Iterator$.MODULE$.continually((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }).flatMap((Function1)new Serializable(coll){
            public static final long serialVersionUID = 0L;
            private final Iterable coll$1;

            public final Iterable<T> apply(int _) {
                return (Iterable)this.coll$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final T apply(T t) {
                        return t;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
            {
                this.coll$1 = coll$1;
            }
        });
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (s.endsWith(oldSuffix)) {
            return new StringBuilder().append((Object)s.substring(0, s.length() - oldSuffix.length())).append((Object)newSuffix).toString();
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock2, Function0<T> fun) {
        lock2.lock();
        try {
            return (T)fun.apply();
        }
        finally {
            lock2.unlock();
        }
    }

    public <T> T inReadLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock2, Function0<T> fun) {
        return this.inLock(lock2.writeLock(), fun);
    }

    public String JSONEscapeString(String s) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(char x0$1) {
                Object object;
                char c = x0$1;
                switch (c) {
                    default: {
                        if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                            object = new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
                            break;
                        }
                        object = BoxesRunTime.boxToCharacter((char)c);
                        break;
                    }
                    case '\t': {
                        object = "\\t";
                        break;
                    }
                    case '\r': {
                        object = "\\r";
                        break;
                    }
                    case '\n': {
                        object = "\\n";
                        break;
                    }
                    case '\f': {
                        object = "\\f";
                        break;
                    }
                    case '\b': {
                        object = "\\b";
                        break;
                    }
                    case '/': {
                        object = "\\/";
                        break;
                    }
                    case '\\': {
                        object = "\\\\";
                        break;
                    }
                    case '\"': {
                        object = "\\\"";
                    }
                }
                return object;
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public <T> Iterable<T> duplicates(Traversable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final T apply(T x) {
                return (T)Predef$.MODULE$.identity(x);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<T, Object> apply(Tuple2<T, Traversable<T>> x0$2) {
                Tuple2<T, Traversable<T>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Traversable l = (Traversable)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<T, Object> x0$3) {
                Tuple2<T, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    int l = tuple2._2$mcI$sp();
                    boolean bl = l > 1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).keys();
    }

    public scala.collection.immutable.Map<SecurityProtocol, EndPoint> listenerListToEndPoints(String listeners) {
        Seq<String> listenerList = this.parseCsvList(listeners);
        return ((TraversableOnce)((TraversableLike)listenerList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final EndPoint apply(String listener) {
                return EndPoint$.MODULE$.createEndPoint(listener);
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<SecurityProtocol, EndPoint> apply(EndPoint ep) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ep.protocolType()), (Object)ep);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSaslProtocol(SecurityProtocol protocol) {
        SecurityProtocol securityProtocol = protocol;
        SecurityProtocol securityProtocol2 = SecurityProtocol.SASL_PLAINTEXT;
        if (securityProtocol == null) {
            if (securityProtocol2 == null) return true;
        } else if (securityProtocol.equals(securityProtocol2)) return true;
        SecurityProtocol securityProtocol3 = protocol;
        SecurityProtocol securityProtocol4 = SecurityProtocol.PLAINTEXTSASL;
        if (securityProtocol3 != null) {
            if (!securityProtocol3.equals(securityProtocol4)) return false;
            return true;
        }
        if (securityProtocol4 == null) return true;
        return false;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return this.urlSafeBase64EncodeNoPadding(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public String urlSafeBase64EncodeNoPadding(byte[] data) {
        String base64EncodedUUID = DatatypeConverter.printBase64Binary((byte[])data);
        String urlSafeBase64EncodedUUID = base64EncodedUUID.replace("+", "-").replace("/", "_");
        return urlSafeBase64EncodedUUID.substring(0, urlSafeBase64EncodedUUID.length() - 2);
    }

    public Properties propsWith(String key, String value2) {
        return this.propsWith((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value2)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final Object apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.properties$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        return var2_2;
    }

    private CoreUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

