/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.Common;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RpcOutboundMessage;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.TabletClient;
import org.apache.kudu.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.client.shaded.com.google.common.net.HostAndPort;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.DefaultChannelPipeline;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.socket.SocketChannel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.socket.SocketChannelConfig;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class ConnectionCache {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionCache.class);
    @GuardedBy(value="lock")
    private final HashMap<String, TabletClient> uuid2client = new HashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.readLock();
    private final AsyncKuduClient kuduClient;

    ConnectionCache(AsyncKuduClient client) {
        this.kuduClient = client;
    }

    ServerInfo connectTS(Master.TSInfoPB tsInfoPB) throws UnknownHostException {
        List<Common.HostPortPB> addresses = tsInfoPB.getRpcAddressesList();
        String uuid = tsInfoPB.getPermanentUuid().toStringUtf8();
        if (addresses.isEmpty()) {
            LOG.warn("Received a tablet server with no addresses, UUID: {}", (Object)uuid);
            return null;
        }
        HostAndPort hostPort = ProtobufHelper.hostAndPortFromPB(addresses.get(0));
        InetAddress inetAddress = NetUtil.getInetAddress(hostPort.getHostText());
        if (inetAddress == null) {
            throw new UnknownHostException("Failed to resolve the IP of `" + addresses.get(0).getHost() + "'");
        }
        return this.newClient(new ServerInfo(uuid, hostPort, inetAddress)).getServerInfo();
    }

    TabletClient newMasterClient(HostAndPort hostPort) {
        return this.newClient("master-" + hostPort.toString(), hostPort);
    }

    TabletClient newClient(String uuid, HostAndPort hostPort) {
        InetAddress inetAddress = NetUtil.getInetAddress(hostPort.getHostText());
        if (inetAddress == null) {
            return null;
        }
        ServerInfo serverInfo = new ServerInfo(uuid, hostPort, inetAddress);
        return this.newClient(serverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TabletClient newClient(ServerInfo serverInfo) {
        SocketChannel chan;
        TabletClient client;
        this.writeLock.lock();
        try {
            client = this.uuid2client.get(serverInfo.getUuid());
            if (client != null && client.isAlive()) {
                TabletClient tabletClient = client;
                return tabletClient;
            }
            TabletClientPipeline pipeline = new TabletClientPipeline();
            client = pipeline.init(serverInfo);
            chan = this.kuduClient.getChannelFactory().newChannel(pipeline);
            this.uuid2client.put(serverInfo.getUuid(), client);
        }
        finally {
            this.writeLock.unlock();
        }
        SocketChannelConfig config = chan.getConfig();
        config.setConnectTimeoutMillis(5000);
        config.setTcpNoDelay(true);
        config.setKeepAlive(true);
        chan.connect(new InetSocketAddress(serverInfo.getResolvedAddress(), serverInfo.getPort()));
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TabletClient getClient(String uuid) {
        this.readLock.lock();
        try {
            TabletClient tabletClient = this.uuid2client.get(uuid);
            return tabletClient;
        }
        finally {
            this.readLock.unlock();
        }
    }

    TabletClient getLiveClient(String uuid) {
        TabletClient client = this.getClient(uuid);
        if (client == null) {
            return null;
        }
        if (client.isAlive()) {
            return client;
        }
        return this.newClient(client.getServerInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Deferred<ArrayList<Void>> disconnectEverything() {
        this.readLock.lock();
        try {
            ArrayList deferreds = new ArrayList(this.uuid2client.size());
            for (TabletClient ts : this.uuid2client.values()) {
                deferreds.add(ts.shutdown());
            }
            Deferred<ArrayList<Void>> deferred = Deferred.group(deferreds);
            return deferred;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TabletClient> getImmutableTabletClientsList() {
        this.readLock.lock();
        try {
            ImmutableList<TabletClient> immutableList = ImmutableList.copyOf(this.uuid2client.values());
            return immutableList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean allConnectionsAreDead() {
        this.readLock.lock();
        try {
            for (TabletClient tserver : this.uuid2client.values()) {
                if (!tserver.isAlive()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    private final class TabletClientPipeline
    extends DefaultChannelPipeline {
        private TabletClientPipeline() {
        }

        TabletClient init(ServerInfo serverInfo) {
            super.addFirst("decode-frames", new LengthFieldBasedFrameDecoder(0x10000000, 0, 4, 0, 4));
            super.addLast("decode-inbound", new CallResponse.Decoder());
            super.addLast("encode-outbound", new RpcOutboundMessage.Encoder());
            AsyncKuduClient kuduClient = ConnectionCache.this.kuduClient;
            TabletClient client = new TabletClient(kuduClient, serverInfo);
            if (kuduClient.getDefaultSocketReadTimeoutMs() > 0L) {
                super.addLast("timeout-handler", new ReadTimeoutHandler(kuduClient.getTimer(), kuduClient.getDefaultSocketReadTimeoutMs(), TimeUnit.MILLISECONDS));
            }
            super.addLast("kudu-handler", client);
            return client;
        }
    }
}

