/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ErrorCollector {
    private final Queue<RowError> errorQueue;
    private final int maxCapacity;
    private boolean overflowed;

    public ErrorCollector(int maxCapacity) {
        Preconditions.checkArgument(maxCapacity > 0, "Need to be able to store at least one row error");
        this.maxCapacity = maxCapacity;
        this.errorQueue = new ArrayDeque<RowError>(maxCapacity);
    }

    public synchronized void addError(RowError rowError) {
        if (this.errorQueue.size() >= this.maxCapacity) {
            this.errorQueue.poll();
            this.overflowed = true;
        }
        this.errorQueue.add(rowError);
    }

    public synchronized int countErrors() {
        return this.errorQueue.size();
    }

    public synchronized RowErrorsAndOverflowStatus getErrors() {
        RowError[] returnedErrors = new RowError[this.errorQueue.size()];
        this.errorQueue.toArray(returnedErrors);
        this.errorQueue.clear();
        RowErrorsAndOverflowStatus returnObject = new RowErrorsAndOverflowStatus(returnedErrors, this.overflowed);
        this.overflowed = false;
        return returnObject;
    }
}

