/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import java.util.List;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.spark.kudu.KuduContext;
import org.apache.kudu.spark.kudu.KuduPartition;
import org.apache.kudu.spark.kudu.RowIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u00011\u0011qaS;ekJ#EI\u0003\u0002\u0004\t\u0005!1.\u001e3v\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\u0004\u000f)\u0011\u0001\"C\u0001\u0007CB\f7\r[3\u000b\u0003)\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0007\u0011\u00079\u0011B#D\u0001\u0010\u0015\t\u0001\u0012#A\u0002sI\u0012T!!B\u0004\n\u0005My!a\u0001*E\tB\u0011Q\u0003G\u0007\u0002-)\u0011q#E\u0001\u0004gFd\u0017BA\r\u0017\u0005\r\u0011vn\u001e\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005Y1.\u001e3v\u0007>tG/\u001a=u+\u0005i\u0002C\u0001\u0010 \u001b\u0005\u0011\u0011B\u0001\u0011\u0003\u0005-YU\u000fZ;D_:$X\r\u001f;\t\u0011\t\u0002!\u0011!Q\u0001\nu\tAb[;ek\u000e{g\u000e^3yi\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\nE\u0006$8\r[*ju\u0016,\u0012A\n\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nA\u0001\\1oO*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u001dIe\u000e^3hKJD\u0001b\f\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000bE\u0006$8\r[*ju\u0016\u0004\u0003F\u0001\u00182!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u00059\u0001\t\u0015\r\u0011\"\u0001:\u00035\u0001(o\u001c6fGR,GmQ8mgV\t!\bE\u00023wuJ!\u0001P\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0005y\neB\u0001\u001a@\u0013\t\u00015'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!4\u0011!)\u0005A!A!\u0002\u0013Q\u0014A\u00049s_*,7\r^3e\u0007>d7\u000f\t\u0015\u0003\tFB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!S\u0001\u000baJ,G-[2bi\u0016\u001cX#\u0001&\u0011\u0007IZ4\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\r\u000511\r\\5f]RL!\u0001U'\u0003\u001b-+H-\u001e)sK\u0012L7-\u0019;f\u0011!\u0011\u0006A!A!\u0002\u0013Q\u0015a\u00039sK\u0012L7-\u0019;fg\u0002B#!U\u0019\t\u0011U\u0003!Q1A\u0005\u0002Y\u000bQ\u0001^1cY\u0016,\u0012a\u0016\t\u0003\u0019bK!!W'\u0003\u0013-+H-\u001e+bE2,\u0007\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011B,\u0002\rQ\f'\r\\3!Q\tQ\u0016\u0007\u0003\u0005_\u0001\t\u0015\r\u0011\"\u0001`\u0003\t\u00198-F\u0001a!\t\t'-D\u0001\u0012\u0013\t\u0019\u0017C\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003a\u0003\r\u00198\r\t\u0015\u0003IFBa\u0001\u001b\u0001\u0005\u0002\tI\u0017A\u0002\u001fj]&$h\bF\u0004kW2lgn\u001c9\u0011\u0005y\u0001\u0001\"B\u000eh\u0001\u0004i\u0002\"\u0002\u0013h\u0001\u00041\u0003\"\u0002\u001dh\u0001\u0004Q\u0004\"\u0002%h\u0001\u0004Q\u0005\"B+h\u0001\u00049\u0006\"\u00020h\u0001\u0004\u0001\u0007\"\u0002:\u0001\t#\u001a\u0018!D4fiB\u000b'\u000f^5uS>t7/F\u0001u!\r\u00114(\u001e\t\u0003CZL!a^\t\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B=\u0001\t\u0003R\u0018aB2p[B,H/\u001a\u000b\u0006w\u0006=\u00111\u0003\t\u0005y\u0006%ACD\u0002~\u0003\u000bq1A`A\u0002\u001b\u0005y(bAA\u0001\u0017\u00051AH]8pizJ\u0011\u0001N\u0005\u0004\u0003\u000f\u0019\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\tiA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t9a\r\u0005\u0007\u0003#A\b\u0019A;\u0002\tA\f'\u000f\u001e\u0005\b\u0003+A\b\u0019AA\f\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\u0007\u0005\fI\"C\u0002\u0002\u001cE\u00111\u0002V1tW\u000e{g\u000e^3yi\"9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0012!F4fiB\u0013XMZ3se\u0016$Gj\\2bi&|gn\u001d\u000b\u0005\u0003G\tI\u0003\u0005\u0003}\u0003Ki\u0014\u0002BA\u0014\u0003\u001b\u00111aU3r\u0011\u001d\tY#!\bA\u0002U\f\u0011\u0002]1si&$\u0018n\u001c8")
public class KuduRDD
extends RDD<Row> {
    private final KuduContext kuduContext;
    private final transient Integer batchSize;
    private final transient String[] projectedCols;
    private final transient KuduPredicate[] predicates;
    private final transient KuduTable table;
    private final transient SparkContext sc;

    public KuduContext kuduContext() {
        return this.kuduContext;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public String[] projectedCols() {
        return this.projectedCols;
    }

    public KuduPredicate[] predicates() {
        return this.predicates;
    }

    public KuduTable table() {
        return this.table;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public Partition[] getPartitions() {
        KuduScanToken.KuduScanTokenBuilder builder = (KuduScanToken.KuduScanTokenBuilder)((AbstractKuduScannerBuilder)((AbstractKuduScannerBuilder)this.kuduContext().syncClient().newScanTokenBuilder(this.table()).batchSizeBytes(Predef$.MODULE$.Integer2int(this.batchSize()))).setProjectedColumnNames((List)JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.refArrayOps((Object[])this.projectedCols()).toSeq()).asJava())).cacheBlocks(true);
        Predef$.MODULE$.refArrayOps((Object[])this.predicates()).foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final KuduScanToken.KuduScanTokenBuilder builder$1;

            public final KuduScanToken.KuduScanTokenBuilder apply(KuduPredicate predicate) {
                return (KuduScanToken.KuduScanTokenBuilder)this.builder$1.addPredicate(predicate);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        Buffer tokens = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter((List)builder.build()).asScala();
        return (Partition[])((TraversableOnce)((TraversableLike)tokens.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KuduPartition apply(Tuple2<KuduScanToken, Object> x0$1) {
                Tuple2<KuduScanToken, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    KuduScanToken token = (KuduScanToken)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    KuduPartition kuduPartition = new KuduPartition(index, token.serialize(), (String[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(token.getTablet().getReplicas()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(LocatedTablet.Replica x$1) {
                            return x$1.getRpcHost();
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
                    return kuduPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<Row> compute(Partition part, TaskContext taskContext) {
        KuduClient client = this.kuduContext().syncClient();
        KuduPartition partition = (KuduPartition)part;
        KuduScanner scanner = KuduScanToken.deserializeIntoScanner(partition.scanToken(), client);
        return new RowIterator(scanner);
    }

    public Seq<String> getPreferredLocations(Partition partition) {
        return Predef$.MODULE$.wrapRefArray((Object[])((KuduPartition)partition).locations());
    }

    public KuduRDD(KuduContext kuduContext, Integer batchSize, String[] projectedCols, KuduPredicate[] predicates, KuduTable table, SparkContext sc) {
        this.kuduContext = kuduContext;
        this.batchSize = batchSize;
        this.projectedCols = projectedCols;
        this.predicates = predicates;
        this.table = table;
        this.sc = sc;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Row.class));
    }
}

