/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.util.GetOpt;

public class LDAPDelete
extends LDAPTool {
    private static String[] m_delete_dn = null;
    private static boolean m_cont = false;
    private static BufferedReader m_reader = null;

    public static void main(String[] args) {
        if (args.length < 1) {
            LDAPDelete.doUsage();
            System.exit(1);
        }
        LDAPDelete.extractParameters(args);
        if (!m_justShow) {
            try {
                m_client = new LDAPConnection();
                m_client.connect(m_ldaphost, m_ldapport);
            }
            catch (Exception e) {
                System.err.println("Error: client connection failed!");
                System.exit(1);
            }
            try {
                m_client.authenticate(m_version, m_binddn, m_passwd);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                System.exit(1);
            }
            LDAPDelete.dodelete();
            try {
                m_client.disconnect();
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        } else {
            LDAPDelete.dodelete(null);
        }
        System.exit(0);
    }

    private static void doUsage() {
        System.err.println("usage: LDAPDelete [options] dn");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -f file      read DNs to delete from file");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -c            continuous mode (do not stop on errors)");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    protected static void extractParameters(String[] args) {
        GetOpt options = LDAPTool.extractParameters("Hcf:", args);
        if (options.hasOption('H')) {
            LDAPDelete.doUsage();
            System.exit(0);
        }
        if (options.hasOption('c')) {
            m_cont = true;
        }
        if (options.hasOption('f')) {
            String filename = options.getOptionParam('f');
            if (filename == null) {
                LDAPDelete.doUsage();
                System.exit(0);
            }
            try {
                FileInputStream fs = new FileInputStream(filename);
                DataInputStream ds = new DataInputStream(fs);
                m_reader = new BufferedReader(new InputStreamReader(ds));
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + filename + " not found");
            }
            catch (IOException e) {
                System.err.println("Error in opening the file " + filename);
            }
        }
        if (m_reader == null) {
            Enumeration pa = options.getParameters().elements();
            Vector vec = new Vector();
            while (pa.hasMoreElements()) {
                vec.addElement(pa.nextElement());
            }
            if (vec.size() <= 0) {
                LDAPDelete.doUsage();
                System.exit(0);
            }
            m_delete_dn = new String[vec.size()];
            vec.copyInto(m_delete_dn);
        }
    }

    private static void dodelete() {
        boolean msgid = false;
        LDAPConstraints cons = m_client.getConstraints();
        Vector<LDAPControl> controlVector = new Vector<LDAPControl>();
        if (m_proxyControl != null) {
            controlVector.addElement(m_proxyControl);
        }
        if (m_ordinary) {
            controlVector.addElement(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
        }
        if (controlVector.size() > 0) {
            Object[] controls = new LDAPControl[controlVector.size()];
            controlVector.copyInto(controls);
            cons.setServerControls((LDAPControl[])controls);
        }
        cons.setReferrals(m_referrals);
        if (m_referrals) {
            LDAPDelete.setDefaultReferralCredentials(cons);
        }
        cons.setHopLimit(m_hopLimit);
        LDAPDelete.dodelete(cons);
    }

    private static void dodelete(LDAPConstraints cons) {
        try {
            if (m_reader == null) {
                for (int i = 0; i < m_delete_dn.length; ++i) {
                    if (LDAPDelete.deleteEntry(m_delete_dn[i], cons) || m_cont) continue;
                    return;
                }
            } else {
                String dn = null;
                while ((dn = m_reader.readLine()) != null) {
                    if (LDAPDelete.deleteEntry(dn, cons) || m_cont) continue;
                    return;
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error in reading input");
        }
    }

    private static boolean deleteEntry(String dn, LDAPConstraints cons) {
        if (m_verbose) {
            System.err.println("Deleting entry: " + dn);
        }
        if (!m_justShow) {
            try {
                m_client.delete(dn, cons);
            }
            catch (LDAPException ee) {
                System.err.println("Delete " + dn + " failed ");
                System.err.println("\t" + ee.errorCodeToString());
                System.err.println("\tmatched " + ee.getMatchedDN() + "\n");
                return false;
            }
        }
        return true;
    }
}

