/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;

public class BERObjectId
extends BERElement {
    private int[] m_value = null;

    public BERObjectId(int[] value) {
        this.m_value = new int[value.length];
        System.arraycopy(value, 0, this.m_value, 0, value.length);
    }

    public BERObjectId(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ".");
        this.m_value = new int[tokenizer.countTokens()];
        for (int i = 0; i < this.m_value.length; ++i) {
            this.m_value[i] = Integer.parseInt(tokenizer.nextToken());
        }
    }

    public BERObjectId(InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        bytes_read[0] = bytes_read[0] + contents_length;
        int[] contents_read = new int[1];
        Vector<Integer> oid = new Vector<Integer>(10);
        contents_read[0] = 0;
        int sub_id = this.readSubIdentifier(stream, contents_read);
        contents_length -= contents_read[0];
        if (sub_id < 40) {
            oid.addElement(new Integer(0));
        } else if (sub_id < 80) {
            oid.addElement(new Integer(1));
        } else {
            oid.addElement(new Integer(2));
        }
        oid.addElement(new Integer(sub_id - (Integer)oid.elementAt(oid.size() - 1) * 40));
        while (contents_length > 0) {
            contents_read[0] = 0;
            sub_id = this.readSubIdentifier(stream, contents_read);
            contents_length -= contents_read[0];
            oid.addElement(new Integer(sub_id));
        }
        this.m_value = new int[oid.size()];
        for (int i = 0; i < oid.size(); ++i) {
            this.m_value[i] = (Integer)oid.elementAt(i);
        }
    }

    public void write(OutputStream stream) throws IOException {
        stream.write(6);
        ByteArrayOutputStream contents_stream = new ByteArrayOutputStream();
        this.writeSubIdentifier(contents_stream, this.m_value[0] * 40 + this.m_value[1]);
        for (int i = 2; i < this.m_value.length; ++i) {
            this.writeSubIdentifier(contents_stream, this.m_value[i]);
        }
        byte[] contents_buffer = contents_stream.toByteArray();
        BERObjectId.sendDefiniteLength(stream, contents_buffer.length);
        stream.write(contents_buffer);
    }

    private int readSubIdentifier(InputStream stream, int[] bytes_read) throws IOException {
        int octet;
        int sub_id = 0;
        do {
            octet = stream.read();
            bytes_read[0] = bytes_read[0] + 1;
            sub_id = sub_id << 7 | octet & 0x7F;
        } while ((octet & 0x80) > 0);
        return sub_id;
    }

    private void writeSubIdentifier(OutputStream stream, int value) throws IOException {
        ByteArrayOutputStream sub_id_stream = new ByteArrayOutputStream();
        while (value > 0) {
            sub_id_stream.write(value & 0x7F);
            value >>= 7;
        }
        byte[] sub_id_buffer = sub_id_stream.toByteArray();
        for (int i = sub_id_buffer.length - 1; i > 0; --i) {
            stream.write(sub_id_buffer[i] | 0x80);
        }
        stream.write(sub_id_buffer[0]);
    }

    public int[] getValue() {
        return this.m_value;
    }

    public int getType() {
        return 6;
    }

    public String toString() {
        if (this.m_value == null) {
            return "ObjectIdentifier (null)";
        }
        String oid = "";
        for (int i = 0; i < this.m_value.length; ++i) {
            if (i != 0) {
                oid = oid + " ";
            }
            oid = oid + this.m_value[i];
        }
        return "ObjectIdentifier {" + oid + "}";
    }
}

