/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERUTCTime
extends BERElement {
    private String m_value = null;
    private byte[] byte_buf;

    public BERUTCTime(String utc_string) {
        this.m_value = utc_string;
    }

    public BERUTCTime(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        int contents_length;
        int[] component_length = new int[1];
        BERElement element = null;
        this.m_value = "";
        if (contents_length == -1) {
            component_length[0] = 0;
            element = BERUTCTime.getElement(decoder, stream, component_length);
            if (element != null) {
                BERUTCTime utc_element = (BERUTCTime)element;
                this.m_value = this.m_value + utc_element.getValue();
            }
            while (element != null) {
            }
        } else {
            bytes_read[0] = bytes_read[0] + contents_length;
            for (contents_length = BERElement.readLengthOctets(stream, bytes_read); contents_length > 0; contents_length -= component_length[0]) {
                component_length[0] = 0;
                element = BERUTCTime.getElement(decoder, stream, component_length);
                if (element == null) continue;
                BERUTCTime utc_element = (BERUTCTime)element;
                this.m_value = this.m_value + utc_element.getValue();
            }
        }
    }

    public BERUTCTime(InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = BERElement.readLengthOctets(stream, bytes_read);
        if (contents_length > 0) {
            byte[] byte_buf = new byte[contents_length];
            for (int i = 0; i < contents_length; ++i) {
                byte_buf[i] = (byte)stream.read();
            }
            bytes_read[0] = bytes_read[0] + contents_length;
            try {
                this.m_value = new String(byte_buf, "UTF8");
            }
            catch (Throwable x) {
                // empty catch block
            }
        }
    }

    public void write(OutputStream stream) throws IOException {
        stream.write((byte)this.getType());
        if (this.m_value == null) {
            BERUTCTime.sendDefiniteLength(stream, 0);
        } else {
            try {
                this.byte_buf = this.m_value.getBytes("UTF8");
                BERUTCTime.sendDefiniteLength(stream, this.byte_buf.length);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stream.write(this.byte_buf, 0, this.byte_buf.length);
        }
    }

    public String getValue() {
        return this.m_value;
    }

    public int getType() {
        return 23;
    }

    public String toString() {
        if (this.m_value == null) {
            return "UTCTime (null)";
        }
        return "UTCTime {" + this.m_value + "}";
    }
}

