/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPTLSSocketFactory;

public class JSSESocketFactory
implements LDAPTLSSocketFactory,
Serializable {
    static final long serialVersionUID = 6834205777733266610L;
    protected String[] suites;
    protected SSLSocketFactory factory;

    public JSSESocketFactory() {
        this(null, null);
    }

    public JSSESocketFactory(String[] suites) {
        this(suites, null);
    }

    public JSSESocketFactory(String[] suites, SSLSocketFactory factory) {
        this.suites = suites;
        this.factory = factory != null ? factory : (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        SSLSocket sock = null;
        try {
            sock = (SSLSocket)this.factory.createSocket(host, port);
            if (this.suites != null) {
                sock.setEnabledCipherSuites(this.suites);
            }
            sock.startHandshake();
        }
        catch (UnknownHostException e) {
            throw new LDAPException("JSSESocketFactory.makeSocket - Unknown host: " + host, 91);
        }
        catch (IOException f) {
            throw new LDAPException("JSSESocketFactory.makeSocket " + host + ":" + port + ", " + f.getMessage(), 91);
        }
        return sock;
    }

    public Socket makeSocket(Socket s) throws LDAPException {
        SSLSocket sock = null;
        String host = s.getInetAddress().getHostName();
        int port = s.getPort();
        try {
            sock = (SSLSocket)this.factory.createSocket(s, host, port, true);
            if (this.suites != null) {
                sock.setEnabledCipherSuites(this.suites);
            }
            sock.startHandshake();
        }
        catch (IOException f) {
            throw new LDAPException("JSSESocketFactory - start TLS, " + f.getMessage(), 112);
        }
        return sock;
    }
}

