/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.factory;

import java.io.Serializable;
import java.net.Socket;
import java.net.UnknownHostException;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPTLSSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

public class JSSSocketFactory
implements Serializable,
LDAPTLSSocketFactory,
SSLCertificateApprovalCallback {
    static final long serialVersionUID = -6926469178017736903L;

    public JSSSocketFactory() throws LDAPException {
        JSSSocketFactory.initialize(".");
    }

    public JSSSocketFactory(String certdbDir) throws LDAPException {
        JSSSocketFactory.initialize(certdbDir);
    }

    public static void initialize(String certdbDir) throws LDAPException {
        try {
            CryptoManager.initialize((String)certdbDir);
        }
        catch (AlreadyInitializedException e) {
        }
        catch (Exception e) {
            throw new LDAPException("Failed to initialize JSSSocketFactory: " + e.getMessage(), 80);
        }
    }

    public Socket makeSocket(String host, int port) throws LDAPException {
        SSLSocket socket = null;
        try {
            socket = new SSLSocket(host, port, null, 0, (SSLCertificateApprovalCallback)this, null);
            socket.forceHandshake();
        }
        catch (UnknownHostException e) {
            throw new LDAPException("JSSSocketFactory.makeSocket - Unknown host: " + host, 91);
        }
        catch (Exception e) {
            throw new LDAPException("JSSSocketFactory.makeSocket " + host + ":" + port + ", " + e.getMessage(), 91);
        }
        return socket;
    }

    public boolean approve(X509Certificate serverCert, SSLCertificateApprovalCallback.ValidityStatus status) {
        return true;
    }

    public Socket makeSocket(Socket s) throws LDAPException {
        SSLSocket socket = null;
        String host = s.getInetAddress().getHostName();
        int port = s.getPort();
        try {
            socket = new SSLSocket(s, host, (SSLCertificateApprovalCallback)this, null);
            socket.forceHandshake();
        }
        catch (Exception e) {
            throw new LDAPException("JSSSocketFactory - start TLS, " + e.getMessage(), 112);
        }
        return socket;
    }
}

