/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFBaseContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModDNContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;
import netscape.ldap.util.MimeBase64Decoder;
import netscape.ldap.util.MimeBase64Encoder;

public class LDIF
implements Serializable {
    private static final char COMMENT = '#';
    static final long serialVersionUID = -2710382547996750924L;
    private int m_version = 1;
    private boolean m_done = false;
    private LineReader m_reader = null;
    private String m_source = null;
    private MimeBase64Decoder m_decoder = null;
    private boolean m_currEntryDone = false;
    private int m_currLineNum;
    private int m_continuationLength;

    public LDIF() throws IOException {
        DataInputStream ds = new DataInputStream(System.in);
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)ds, "UTF8"));
        this.m_reader = new LineReader(d);
        this.m_source = "System.in";
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIF(String file) throws IOException {
        FileInputStream fs = new FileInputStream(file);
        DataInputStream ds = new DataInputStream(fs);
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)ds, "UTF8"));
        this.m_reader = new LineReader(d);
        this.m_source = file;
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIF(DataInputStream ds) throws IOException {
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)ds, "UTF8"));
        this.m_reader = new LineReader(d);
        this.m_source = ds.toString();
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIFRecord nextRecord() throws IOException {
        if (this.m_done) {
            return null;
        }
        return this.parse_ldif_record(this.m_reader);
    }

    private LDIFRecord parse_ldif_record(LineReader d) throws IOException {
        String line = null;
        String dn = null;
        Vector attrs = new Vector();
        LDIFRecord rec = null;
        while ((line = d.readLine()) != null && line.length() < 1) {
        }
        if (line == null) {
            return null;
        }
        if (line.startsWith("version:")) {
            this.m_version = Integer.parseInt(line.substring("version:".length()).trim());
            if (this.m_version != 1) {
                this.throwLDIFException("Unexpected " + line);
            }
            if ((line = d.readLine()) != null && line.length() == 0) {
                line = d.readLine();
            }
            if (line == null) {
                return null;
            }
        }
        if (!line.startsWith("dn:")) {
            this.throwLDIFException("expecting dn:");
        }
        if ((dn = line.substring(3).trim()).startsWith(":") && dn.length() > 1) {
            String substr = dn.substring(1).trim();
            dn = new String(this.getDecodedBytes(substr), "UTF8");
        }
        LDIFContent content = this.parse_ldif_content(d);
        rec = new LDIFRecord(dn, content);
        return rec;
    }

    private LDIFContent parse_ldif_content(LineReader d) throws IOException {
        Vector<LDAPControl> controlVector;
        Hashtable<String, LDAPAttribute> ht;
        block28: {
            String line = d.readLine();
            if (line == null || line.length() < 1 || line.equals("-")) {
                if (line != null && line.length() < 1) {
                    this.m_currEntryDone = true;
                }
                return null;
            }
            if (line.startsWith("changetype:")) {
                LDIFBaseContent lc = null;
                String changetype = line.substring(11).trim();
                if (changetype.equals("modify")) {
                    lc = this.parse_mod_spec(d);
                } else if (changetype.equals("add")) {
                    lc = this.parse_add_spec(d);
                } else if (changetype.equals("delete")) {
                    lc = this.parse_delete_spec(d);
                } else if (changetype.equals("moddn") || changetype.equals("modrdn")) {
                    lc = this.parse_moddn_spec(d);
                } else {
                    this.throwLDIFException("change type not supported");
                }
                return lc;
            }
            ht = new Hashtable<String, LDAPAttribute>();
            String newtype = null;
            Object val = null;
            LDAPAttribute newAttr = null;
            controlVector = null;
            do {
                if (line.startsWith("control:")) {
                    if (controlVector == null) {
                        controlVector = new Vector<LDAPControl>();
                    }
                    controlVector.addElement(this.parse_control_spec(line));
                    continue;
                }
                int len = line.length();
                if (len < 1) break block28;
                int idx = line.indexOf(58);
                if (idx == -1) {
                    this.throwLDIFException("no ':' found");
                }
                newtype = line.substring(0, idx).toLowerCase();
                val = "";
                if (len > ++idx) {
                    if (line.charAt(idx) == ':') {
                        String substr = line.substring(++idx).trim();
                        val = this.getDecodedBytes(substr);
                    } else if (line.charAt(idx) == '<') {
                        try {
                            URL url = new URL(line.substring(idx + 1).trim());
                            String filename = url.getFile();
                            val = this.getFileContent(filename);
                        }
                        catch (MalformedURLException ex) {
                            this.throwLDIFException(ex + ": cannot construct url " + line.substring(idx + 1).trim());
                        }
                    } else {
                        val = line.substring(idx).trim();
                    }
                }
                if ((newAttr = (LDAPAttribute)ht.get(newtype)) == null) {
                    newAttr = new LDAPAttribute(newtype);
                }
                if (val instanceof String) {
                    newAttr.addValue((String)val);
                } else {
                    newAttr.addValue((byte[])val);
                }
                ht.put(newtype, newAttr);
            } while ((line = d.readLine()) != null && line.length() >= 1 && !line.equals("-"));
            if (line != null && line.length() < 1) {
                this.m_currEntryDone = true;
            }
        }
        LDIFAttributeContent ac = new LDIFAttributeContent();
        Enumeration en = ht.elements();
        while (en.hasMoreElements()) {
            ac.addElement((LDAPAttribute)en.nextElement());
        }
        ht.clear();
        if (controlVector != null) {
            Object[] controls = new LDAPControl[controlVector.size()];
            controlVector.copyInto(controls);
            ac.setControls((LDAPControl[])controls);
            controlVector.removeAllElements();
        }
        return ac;
    }

    private byte[] getDecodedBytes(String line) {
        ByteBuf inBuf = new ByteBuf(line);
        ByteBuf decodedBuf = new ByteBuf();
        this.m_decoder.translate(inBuf, decodedBuf);
        return decodedBuf.toBytes();
    }

    private byte[] getFileContent(String url) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(url, "|");
        String filename = url;
        int num = tokenizer.countTokens();
        if (num == 2) {
            String token = (String)tokenizer.nextElement();
            int index = token.lastIndexOf("/");
            String drive = token.substring(index + 1);
            token = (String)tokenizer.nextElement();
            token = token.replace('/', '\\');
            filename = drive + ":" + token;
        }
        File file = new File(filename);
        byte[] b = new byte[(int)file.length()];
        FileInputStream fi = new FileInputStream(filename);
        fi.read(b);
        return b;
    }

    private LDIFAddContent parse_add_spec(LineReader d) throws IOException {
        LDIFAttributeContent ac = (LDIFAttributeContent)this.parse_ldif_content(d);
        if (this.m_currEntryDone) {
            this.m_currEntryDone = false;
        }
        LDAPAttribute[] attrs = ac.getAttributes();
        LDIFAddContent rc = new LDIFAddContent(attrs);
        LDAPControl[] controls = ac.getControls();
        if (controls != null) {
            rc.setControls(controls);
        }
        return rc;
    }

    private LDIFDeleteContent parse_delete_spec(LineReader d) throws IOException {
        Vector<LDAPControl> controlVector = null;
        LDIFDeleteContent dc = new LDIFDeleteContent();
        String line = d.readLine();
        while (line != null && !line.equals("")) {
            if (line.startsWith("control:")) {
                if (controlVector == null) {
                    controlVector = new Vector<LDAPControl>();
                }
                controlVector.addElement(this.parse_control_spec(line));
            } else {
                this.throwLDIFException("invalid SEP");
            }
            line = d.readLine();
        }
        if (controlVector != null) {
            Object[] controls = new LDAPControl[controlVector.size()];
            controlVector.copyInto(controls);
            dc.setControls((LDAPControl[])controls);
            controlVector.removeAllElements();
        }
        return dc;
    }

    private LDIFModifyContent parse_mod_spec(LineReader d) throws IOException {
        Vector<LDAPControl> controlVector = null;
        String line = null;
        line = d.readLine();
        LDIFModifyContent mc = new LDIFModifyContent();
        do {
            int oper = -1;
            if (line.startsWith("add:")) {
                oper = 0;
            } else if (line.startsWith("delete:")) {
                oper = 1;
            } else if (line.startsWith("replace:")) {
                oper = 2;
            } else {
                this.throwLDIFException("unknown modify type");
            }
            LDIFAttributeContent ac = (LDIFAttributeContent)this.parse_ldif_content(d);
            if (ac != null) {
                LDAPAttribute[] attrs = ac.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    LDAPModification mod = new LDAPModification(oper, attrs[i]);
                    mc.addElement(mod);
                }
                LDAPControl[] controls = ac.getControls();
                if (controls != null) {
                    if (controlVector == null) {
                        controlVector = new Vector<LDAPControl>();
                    }
                    for (int i = 0; i < controls.length; ++i) {
                        controlVector.addElement(controls[i]);
                    }
                }
            } else {
                int index = line.indexOf(":");
                if (index == -1) {
                    this.throwLDIFException("colon missing in " + line);
                }
                String attrName = line.substring(index + 1).trim();
                if (oper == 0) {
                    this.throwLDIFException("add operation needs the value for attribute " + attrName);
                }
                LDAPAttribute attr = new LDAPAttribute(attrName);
                LDAPModification mod = new LDAPModification(oper, attr);
                mc.addElement(mod);
            }
            if (!this.m_currEntryDone) continue;
            this.m_currEntryDone = false;
            break;
        } while ((line = d.readLine()) != null && !line.equals(""));
        if (controlVector != null) {
            Object[] controls = new LDAPControl[controlVector.size()];
            controlVector.copyInto(controls);
            mc.setControls((LDAPControl[])controls);
            controlVector.removeAllElements();
        }
        return mc;
    }

    private LDIFModDNContent parse_moddn_spec(LineReader d) throws IOException {
        Vector<LDAPControl> controlVector = null;
        String line = null;
        line = d.readLine();
        LDIFModDNContent mc = new LDIFModDNContent();
        Object val = null;
        do {
            if (line.startsWith("newrdn:") && line.length() > "newrdn:".length() + 1) {
                mc.setRDN(line.substring("newrdn:".length()).trim());
                continue;
            }
            if (line.startsWith("deleteoldrdn:") && line.length() > "deleteoldrdn:".length() + 1) {
                String str = line.substring("deleteoldrdn:".length()).trim();
                if (str.equals("0")) {
                    mc.setDeleteOldRDN(false);
                    continue;
                }
                if (str.equals("1")) {
                    mc.setDeleteOldRDN(true);
                    continue;
                }
                this.throwLDIFException("Incorrect input for deleteOldRdn ");
                continue;
            }
            if (line.startsWith("newsuperior:") && line.length() > "newsuperior:".length() + 1) {
                mc.setNewParent(line.substring("newsuperior:".length()).trim());
                continue;
            }
            if (line.startsWith("newparent:") && line.length() > "newparent:".length() + 1) {
                mc.setNewParent(line.substring("newparent:".length()).trim());
                continue;
            }
            if (!line.startsWith("control:")) continue;
            if (controlVector == null) {
                controlVector = new Vector<LDAPControl>();
            }
            controlVector.addElement(this.parse_control_spec(line));
        } while ((line = d.readLine()) != null && !line.equals(""));
        if (controlVector != null) {
            Object[] controls = new LDAPControl[controlVector.size()];
            controlVector.copyInto(controls);
            mc.setControls((LDAPControl[])controls);
            controlVector.removeAllElements();
        }
        return mc;
    }

    protected LDAPControl parse_control_spec(String line) throws IOException {
        String OID;
        boolean criticality = true;
        byte[] val = null;
        int len = line.length();
        int idx = line.indexOf(58) + 2;
        if (idx >= len) {
            this.throwLDIFException("OID required for control");
        }
        if ((idx = (line = line.substring(idx).trim()).indexOf(32)) < 0) {
            OID = line;
        } else {
            OID = line.substring(0, idx);
            String criticalVal = (idx = (line = line.substring(idx + 1)).indexOf(58)) > 0 ? line.substring(0, idx) : line;
            if (criticalVal.compareTo("true") == 0) {
                criticality = true;
            } else if (criticalVal.compareTo("false") == 0) {
                criticality = false;
            } else {
                this.throwLDIFException("Criticality for control must be true or false, not " + criticalVal);
            }
            if (idx > 0 && line.length() > ++idx) {
                if (line.charAt(idx) == ':') {
                    line = line.substring(++idx).trim();
                    val = this.getDecodedBytes(line);
                } else if (line.charAt(idx) == '<') {
                    String urlString = line.substring(idx + 1).trim();
                    try {
                        URL url = new URL(urlString);
                        String filename = url.getFile();
                        val = this.getFileContent(filename);
                    }
                    catch (MalformedURLException ex) {
                        this.throwLDIFException(ex + ": cannot construct url " + urlString);
                    }
                } else {
                    try {
                        val = line.substring(idx).trim().getBytes("UTF8");
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
            }
        }
        return new LDAPControl(OID, criticality, val);
    }

    public static boolean isPrintable(byte[] b) {
        for (int i = b.length - 1; i >= 0; --i) {
            if (b[i] >= 32 && b[i] <= 127 || b[i] == 9) continue;
            return false;
        }
        return true;
    }

    public static void breakString(PrintWriter pw, String value, int max) {
        int toWrite;
        int written = 0;
        int maxChars = max;
        for (int leftToGo = value.length(); leftToGo > 0; leftToGo -= toWrite) {
            toWrite = Math.min(maxChars, leftToGo);
            String s = value.substring(written, written + toWrite);
            if (written != 0) {
                pw.print(" " + s);
            } else {
                pw.print(s);
                --maxChars;
            }
            written += toWrite;
            pw.print('\n');
        }
    }

    public int getVersion() {
        return this.m_version;
    }

    public String toString() {
        return "LDIF {" + this.m_source + "}";
    }

    protected void throwLDIFException(String msg) throws IOException {
        throw new IOException("line " + (this.m_currLineNum - this.m_continuationLength) + ": " + msg);
    }

    public static String toPrintableString(byte[] b) {
        String s = "";
        if (LDIF.isPrintable(b)) {
            try {
                s = new String(b, "UTF8");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            ByteBuf inBuf = new ByteBuf(b, 0, b.length);
            ByteBuf encodedBuf = new ByteBuf();
            MimeBase64Encoder encoder = new MimeBase64Encoder();
            encoder.translate(inBuf, encodedBuf);
            int nBytes = encodedBuf.length();
            if (nBytes > 0) {
                s = new String(encodedBuf.toBytes(), 0, nBytes);
            }
        }
        return s;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java LDIF <FILENAME>");
            System.exit(1);
        }
        LDIF ldif = null;
        try {
            ldif = new LDIF(args[0]);
        }
        catch (Exception e) {
            System.err.println("Failed to read LDIF file " + args[0] + ", " + e.toString());
            System.exit(1);
        }
        try {
            LDIFRecord rec = ldif.nextRecord();
            while (rec != null) {
                System.out.println(rec.toString() + '\n');
                rec = ldif.nextRecord();
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
            System.exit(1);
        }
        System.exit(0);
    }

    class LineReader {
        private BufferedReader _d;
        String _next = null;

        LineReader(BufferedReader d) {
            this._d = d;
        }

        String readLine() throws IOException {
            String line = null;
            String result = null;
            int readCnt = 0;
            int continuationLength = 0;
            while (true) {
                if (this._next != null) {
                    line = this._next;
                    this._next = null;
                } else {
                    line = this._d.readLine();
                }
                if (line == null) break;
                ++readCnt;
                if (line.length() < 1) {
                    if (result == null) {
                        result = line;
                        continue;
                    }
                    this._next = line;
                    break;
                }
                if (line.charAt(0) == '#') continue;
                if (line.charAt(0) != ' ') {
                    if (result == null) {
                        result = line;
                        continue;
                    }
                    this._next = line;
                    break;
                }
                if (result == null) {
                    LDIF.this.m_currLineNum += readCnt;
                    LDIF.this.throwLDIFException("continuation out of nowhere");
                }
                result = result + line.substring(1);
                ++continuationLength;
            }
            LDIF.this.m_done = line == null;
            LDIF.this.m_currLineNum += readCnt;
            if (this._next != null) {
                LDIF.this.m_currLineNum--;
            }
            LDIF.this.m_continuationLength = continuationLength;
            return result;
        }
    }
}

