/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.hbase.HBaseAdminImpl;
import com.mapr.fs.hbase.HTableDescriptorProxy;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.CFPermissions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class CopyMetaHelper {
    private static final Log LOG = LogFactory.getLog(CopyMetaHelper.class);
    public static final int METATYPE_CFS = 1;
    public static final int METATYPE_ATTRS = 2;
    public static final int METATYPE_ACES = 4;
    public static final int METATYPE_SPLITS = 8;
    public static final int METATYPE_ALL = 15;

    public static void createTable(String src, String dst, int metaTypeMask, Dbserver.TableAttr attr, List<String> cfList) throws IOException {
        try {
            Class<?> c = Class.forName("org.apache.hadoop.hbase.HBaseConfiguration");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("mapr-hbase package is not installed or mapr-hbase jar is missing from the classpath");
        }
        Configuration conf = HBaseConfiguration.create();
        CopyMetaHelper.createTable(conf, src, dst, metaTypeMask, attr, cfList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(Configuration conf, String src, String dst, int metaTypeMask, Dbserver.TableAttr attr, List<String> cfList) throws IOException {
        HBaseAdminImpl hadminImpl = null;
        HBaseAdmin hbaseAdmin = null;
        HTable htSrc = null;
        boolean addAllCfs = true;
        try {
            Class<?> c = Class.forName("org.apache.hadoop.hbase.HBaseConfiguration");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("mapr-hbase package is not installed or mapr-hbase jar is missing from the classpath");
        }
        try {
            hbaseAdmin = new HBaseAdmin(conf);
            HTableDescriptor htdDst = new HTableDescriptor();
            if (hbaseAdmin.tableExists(dst.getBytes())) {
                throw new IOException("Table " + dst + " already exists");
            }
            htSrc = new HTable(conf, src);
            HTableDescriptor htdSrc = new HTableDescriptor(htSrc.getTableDescriptor());
            if (cfList != null && !cfList.isEmpty()) {
                addAllCfs = false;
            }
            HTableDescriptorProxy.setName(htdDst, dst.getBytes());
            if ((metaTypeMask & 1) > 0) {
                if (addAllCfs) {
                    for (HColumnDescriptor hcdDst : htdSrc.getColumnFamilies()) {
                        HTableDescriptorProxy.addFamily(htdDst, hcdDst);
                    }
                } else {
                    for (String cf : cfList) {
                        if (!htdSrc.hasFamily(Bytes.toBytes((String)cf))) {
                            throw new IOException("column family " + cf + " does not exist on src table");
                        }
                        HTableDescriptorProxy.addFamily(htdDst, htdSrc.getFamily(Bytes.toBytes((String)cf)));
                    }
                }
            }
            if ((metaTypeMask & 2) > 0) {
                CopyMetaHelper.copyConfigValues(htdSrc, htdDst);
                if (attr != null && attr.hasBulkLoad()) {
                    HTableDescriptorProxy.setValue(htdDst, "BULKLOAD", attr.getBulkLoad() ? "true" : "false");
                }
            }
            if ((metaTypeMask & 8) > 0) {
                byte[][] regionEndKeys = (byte[][])ArrayUtils.remove((Object[])htSrc.getEndKeys(), (int)(htSrc.getEndKeys().length - 1));
                hbaseAdmin.createTable(htdDst, regionEndKeys);
            } else {
                hbaseAdmin.createTable(htdDst);
            }
            if ((metaTypeMask & 4) > 0) {
                conf.set("hbase.table.namespace.mappings", "");
                BaseTableMappingRules tableMappingRule = TableMappingRulesFactory.create((Configuration)conf);
                hadminImpl = new HBaseAdminImpl(conf, tableMappingRule);
                Map<String, String> tablePerms = hadminImpl.getTablePermissions(src);
                if (tablePerms.size() == 0) {
                    LOG.warn((Object)"No aces on source/No access to aces for current user. Creating table with default aces.");
                }
                hadminImpl.setTablePermissions(dst, tablePerms);
                if ((metaTypeMask & 1) > 0) {
                    List<CFPermissions> cfPerms = hadminImpl.getFamilyPermissions(src);
                    for (CFPermissions cfPerm : cfPerms) {
                        if (!addAllCfs && !cfList.contains(cfPerm.getFamily())) continue;
                        hadminImpl.setFamilyPermissions(dst, cfPerm.getFamily(), cfPerm);
                    }
                }
            }
        }
        finally {
            if (hadminImpl != null) {
                hadminImpl.close();
            }
            if (hbaseAdmin != null) {
                hbaseAdmin.close();
            }
            if (htSrc != null) {
                htSrc.close();
            }
        }
    }

    private static void copyConfigValues(HTableDescriptor src, HTableDescriptor dst) {
        Map srcMap = src.getValues();
        for (Map.Entry pairs : srcMap.entrySet()) {
            String key = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getKey()).get());
            String value = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getValue()).get());
            HTableDescriptorProxy.setValue(dst, key, value);
        }
    }
}

