/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.annotation.API;

@API.Internal
class ConditionBlock
extends ConditionNode {
    private BlockType type;
    private List<ConditionNode> children;
    private boolean closed = false;

    ConditionBlock(BlockType type) {
        this.type = type;
        this.children = Lists.newArrayList();
    }

    ConditionBlock(ByteString serializedState) {
        try {
            Dbfilters.FilterListProto proto = Dbfilters.FilterListProto.parseFrom((ByteString)serializedState);
            this.type = proto.getOperator() == Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL ? BlockType.and : BlockType.or;
            ArrayList<ConditionNode> nodeList = new ArrayList<ConditionNode>(proto.getFiltersCount());
            block11: for (Dbfilters.FilterMsg filter : proto.getFiltersList()) {
                String nodeId = filter.getId();
                ByteString nodeState = filter.getSerializedState();
                switch (nodeId) {
                    case "469dbd04": 
                    case "8cbdcd12": {
                        nodeList.add(new ConditionLeaf(nodeId, nodeState));
                        continue block11;
                    }
                    case "a42ebf64": {
                        nodeList.add(new ConditionBlock(nodeState));
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("Unknown filter in the serialized message: " + nodeId);
            }
            this.children = nodeList;
            this.closed = true;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode message", e);
        }
    }

    @Override
    protected ConditionBlock clone() {
        ConditionBlock newBlock = (ConditionBlock)super.clone();
        newBlock.children = Lists.newArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            newBlock.children.add(this.children.get(i).clone());
        }
        return newBlock;
    }

    BlockType getType() {
        return this.type;
    }

    void add(ConditionNode node) {
        this.children.add(node);
    }

    @Override
    public boolean isEmpty() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    boolean isLeaf() {
        return false;
    }

    List<ConditionNode> getChildren() {
        return this.children;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).addProjections(proj);
        }
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        sb.append('(');
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).expressionBuilder(sb);
            if (i >= this.children.size() - 1) continue;
            sb.append(' ').append((Object)this.type).append(' ');
        }
        sb.append(')');
        return sb;
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        int indent = 2 * level;
        ++level;
        sb.append((Object)this.type).append(" [");
        for (ConditionNode node : this.children) {
            sb.append('\n');
            ConditionBlock.indent(sb, indent);
            node.treeBuilder(sb, level);
        }
        if (this.closed) {
            sb.append('\n');
            ConditionBlock.indent(sb, indent - 2).append(']');
        }
        return sb;
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        sb.append('{').append('\"').append('$').append((Object)this.type).append('\"').append(':').append(' ').append('[');
        for (ConditionNode node : this.children) {
            node.jsonBuilder(sb).append(',').append(' ');
        }
        if (sb.charAt(sb.length() - 1) != '[') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']').append('}');
        return sb;
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.FilterListProto.Builder builder = Dbfilters.FilterListProto.newBuilder();
        builder.setOperator(this.type == BlockType.and ? Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL : Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ONE);
        HashMap blockFamilyFieldPathsMap = Maps.newHashMap();
        for (ConditionNode filter : this.children) {
            ConditionDescriptor child = filter.getDescriptor(pathIdMap);
            builder.addFilters(child.getFilterMsg());
            Map<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsMap = child.getFamilyFieldPathsMap();
            for (Map.Entry<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsEntry : childFamilyFieldPathsMap.entrySet()) {
                Integer familyId = childFamilyFieldPathsEntry.getKey();
                Set set = (Set)blockFamilyFieldPathsMap.get(familyId);
                if (set == null) {
                    set = Sets.newTreeSet();
                    blockFamilyFieldPathsMap.put(familyId, set);
                }
                set.addAll((Collection)childFamilyFieldPathsEntry.getValue());
            }
        }
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("a42ebf64").setSerializedState(builder.build().toByteString()).build();
        return new ConditionDescriptor(filterMsg, blockFamilyFieldPathsMap);
    }

    @Override
    List<ConditionNode.RowkeyRange> getRowkeyRanges() {
        if (this.children.size() == 0) {
            return FULL_TABLE_RANGE;
        }
        List<ConditionNode.RowkeyRange> nodeRanges = this.children.get(0).getRowkeyRanges();
        for (int i = 1; i < this.children.size(); ++i) {
            nodeRanges = this.mergeNodeRanges(nodeRanges, this.children.get(i).getRowkeyRanges());
        }
        return nodeRanges;
    }

    ConditionBlock close() {
        this.closed = true;
        return this;
    }

    @Override
    boolean checkAndPrune() {
        if (this.type == BlockType.and) {
            Iterator<ConditionNode> itr = this.children.iterator();
            while (itr.hasNext()) {
                if (!itr.next().checkAndPrune()) continue;
                itr.remove();
            }
        }
        if (this.children.size() == 1 && !this.children.get(0).isLeaf()) {
            ConditionBlock rootBlock = (ConditionBlock)this.children.get(0);
            this.children = rootBlock.children;
            this.type = rootBlock.type;
        }
        return this.children.size() == 0;
    }

    private List<ConditionNode.RowkeyRange> mergeNodeRanges(List<ConditionNode.RowkeyRange> leftRanges, List<ConditionNode.RowkeyRange> rightRanges) {
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] leftStartRow = leftRanges.get(0).getStartRow();
        byte[] leftStopRow = leftRanges.get(0).getStopRow();
        byte[] rightStartRow = rightRanges.get(0).getStartRow();
        byte[] rightStopRow = rightRanges.get(0).getStopRow();
        switch (this.type) {
            case and: {
                startRow = Bytes.maxOfStartRows((byte[])leftStartRow, (byte[])rightStartRow);
                stopRow = Bytes.minOfStopRows((byte[])leftStopRow, (byte[])rightStopRow);
                break;
            }
            case or: {
                startRow = Bytes.minOfStartRows((byte[])leftStartRow, (byte[])rightStartRow);
                stopRow = Bytes.maxOfStopRows((byte[])leftStopRow, (byte[])rightStopRow);
                break;
            }
            default: {
                assert (false) : (Object)((Object)this.type) + " is not handled.";
                break;
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            return ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow));
        }
        return FULL_TABLE_RANGE;
    }

    static enum BlockType {
        and,
        or;

    }
}

