/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.ojai.ContainerContext;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.ojai.MCFContext;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.ControlInfoImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueDeserializeHelper;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.util.MCFTree;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.TypeException;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Types;

@API.Internal
public class DBDocumentReader
implements DBDocumentReaderBase {
    private Map<FieldPath, Integer> jsonPathMap;
    private Map<Integer, ByteBuffer> dataMap;
    private Iterator<Map.Entry<Integer, ByteBuffer>> dataMapIterator;
    private Map.Entry<Integer, ByteBuffer> dataMapEntry;
    private boolean emitId;
    private KeyValue idValue;
    private ByteBuffer rowBuf = null;
    private ByteBuffer defaultRowBuf = null;
    private long currentLongValue = 0L;
    private Object currentObjValue = null;
    private int decimalScale;
    private int decimalPrecision;
    private byte[] decimalUnscaledValue;
    private DocumentReader.EventType currentEvent;
    private DocumentReader.EventType nextEvent = null;
    private DocumentReader.EventType processedEvent = null;
    private DocumentReader.EventType lastEvent = null;
    private int currentCFId;
    private int mapLevel;
    private Stack<ContainerContext> containerStack;
    private ContainerContext currentContainer;
    private Stack<MCFContext> stackOfContext;
    private SerializationContext context;
    private int[] keyValueSize;
    private String fieldName;
    private MCFTree treeMap;
    private boolean doInit = true;
    private MCFTree.Node currentNode = null;
    private boolean doneWithAll = false;
    private String DEFAULT_PATH = "";
    private boolean replaceTopMapFieldName = false;

    public DBDocumentReader(Map<Integer, ByteBuffer> data, Map<FieldPath, Integer> pathMap, KeyValue _id, boolean excludeId) {
        this.jsonPathMap = pathMap;
        this.dataMap = data;
        this.dataMapIterator = this.dataMap.entrySet().iterator();
        this.idValue = _id;
        this.emitId = !excludeId;
        this.decimalPrecision = 0;
        this.decimalScale = 0;
        this.decimalUnscaledValue = null;
        this.runInit();
        this.initMCFTree();
        this.currentNode = this.treeMap.search(0, this.DEFAULT_PATH);
        this.initializeCurrentNode();
    }

    private ByteBuffer checkAndRetrieveBuffer(ByteBuffer buff) {
        if (buff == null) {
            return null;
        }
        ByteBuffer b = buff.duplicate().order(buff.order());
        if (b.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new DecodingException("Byte order of serialized buffer must be little endian.");
        }
        return b;
    }

    private void initializeCurrentNode() {
        for (Map.Entry<FieldPath, Integer> jsonPaths : this.jsonPathMap.entrySet()) {
            if (this.currentCFId != jsonPaths.getValue()) continue;
            String firstKey = ((FieldSegment)jsonPaths.getKey().iterator().next()).getNameSegment().getName();
            if (!firstKey.isEmpty()) {
                this.currentNode = this.currentNode.findChild(firstKey);
                this.replaceTopMapFieldName = true;
            }
            this.rowBuf = this.currentNode.getBuffer();
            return;
        }
    }

    private void runInit() {
        if (this.dataMap != null) {
            this.currentCFId = this.dataMapIterator.next().getKey();
        }
        this.mapLevel = 1;
        this.context = new SerializationContext();
        this.context.setNewRecord(true);
        this.containerStack = new Stack();
        this.currentEvent = DocumentReader.EventType.START_MAP;
        this.currentContainer = this.containerStack.push(new ContainerContext(Value.Type.MAP));
        this.doInit = false;
        this.stackOfContext = new Stack();
    }

    private void initMCFTree() {
        this.treeMap = new MCFTree();
        for (Map.Entry<FieldPath, Integer> jsonPaths : this.jsonPathMap.entrySet()) {
            FieldPath p = jsonPaths.getKey();
            if (p.asPathString().isEmpty()) {
                ByteBuffer buff;
                this.rowBuf = buff = this.checkAndRetrieveBuffer(this.dataMap.get(jsonPaths.getValue()));
                this.treeMap.addBuffer(this.mapLevel, p.asPathString(), buff);
                continue;
            }
            ByteBuffer cfBuffer = this.checkAndRetrieveBuffer(this.dataMap.get(jsonPaths.getValue()));
            if (cfBuffer == null) continue;
            Iterator iter = p.iterator();
            String parent = this.DEFAULT_PATH;
            int i = 0;
            while (iter.hasNext()) {
                String currentKey = ((FieldSegment)iter.next()).getNameSegment().getName();
                try {
                    this.treeMap.insertNode(this.mapLevel + i + 1, currentKey, parent, null);
                    ++i;
                    parent = currentKey;
                }
                catch (Exception e) {
                    System.err.println("Error processing JSON paths : " + e.getMessage());
                }
            }
            this.treeMap.addBuffer(this.mapLevel + i, parent, cfBuffer);
        }
    }

    private MCFTree.Node childrenToVisit() {
        if (this.currentNode.getLevel() < this.mapLevel - 1) {
            return null;
        }
        Map<String, MCFTree.Node> children = this.currentNode.getChildren();
        if (children != null) {
            for (Map.Entry<String, MCFTree.Node> c : children.entrySet()) {
                MCFTree.Node n = c.getValue();
                if (n.isVisited()) continue;
                return n;
            }
        }
        return null;
    }

    private void moveToChildNode(DocumentReader.EventType lEvent, boolean pushSerializationContext, boolean getType) {
        SerializationContext newContext = new SerializationContext();
        newContext.setNewRecord(true);
        if (pushSerializationContext) {
            this.stackOfContext.push(new MCFContext(this.context, lEvent));
        }
        this.context = newContext;
        this.rowBuf = this.currentNode.getBuffer();
        if (getType) {
            this.getNextType();
        }
    }

    private void moveToParentNode() {
        this.currentNode.setVisited();
        this.currentNode = this.treeMap.search(this.currentNode.getLevel() - 1, this.currentNode.getParent());
    }

    private void fixFieldNameInStack() {
        if (this.currentEvent == DocumentReader.EventType.START_MAP) {
            ContainerContext lastContext = this.containerStack.pop();
            if (!lastContext.isMap()) {
                throw new IllegalStateException("Expected map context");
            }
            this.containerStack.push(new ContainerContext(Value.Type.MAP, this.fieldName));
        }
    }

    private void dfsVisit() {
        if (this.doneWithAll) {
            return;
        }
        if (this.rowBuf.hasRemaining()) {
            this.getNextType();
            if (this.currentEvent == DocumentReader.EventType.START_MAP) {
                if (!this.inMap()) {
                    return;
                }
                MCFTree.Node childNode = this.currentNode.findChild(this.getFieldName());
                if (childNode != null) {
                    this.currentNode = childNode;
                    if (this.currentNode.hasBuffer()) {
                        this.moveToChildNode(null, true, false);
                        this.fieldName = childNode.getFieldName();
                    }
                    return;
                }
            } else if (this.currentEvent == DocumentReader.EventType.END_MAP) {
                MCFTree.Node nextNode = this.childrenToVisit();
                if (nextNode != null) {
                    this.currentNode = nextNode;
                    this.containerStack.push(new ContainerContext(Value.Type.MAP, this.fieldName));
                    this.context.setIsArrayElement(false);
                    if (this.currentNode.hasBuffer()) {
                        this.moveToChildNode(this.currentEvent, true, true);
                        this.fieldName = this.currentNode.getFieldName();
                        return;
                    }
                    this.currentNode.setVisited();
                    this.stackOfContext.push(new MCFContext(this.context, this.currentEvent));
                    this.currentEvent = DocumentReader.EventType.START_MAP;
                    ++this.mapLevel;
                    this.fieldName = this.currentNode.getFieldName();
                } else {
                    --this.mapLevel;
                    if (this.currentNode.getLevel() > this.mapLevel && this.currentNode.isSubtreeVisited()) {
                        this.moveToParentNode();
                        MCFTree.Node c = this.childrenToVisit();
                        if (c != null) {
                            ++this.mapLevel;
                            this.containerStack.push(new ContainerContext(Value.Type.MAP, this.fieldName));
                            this.currentNode = c;
                            if (this.currentNode.hasBuffer()) {
                                this.moveToChildNode(null, false, true);
                            } else {
                                c = this.childrenToVisit();
                                this.currentEvent = DocumentReader.EventType.START_MAP;
                            }
                            this.fieldName = this.currentNode.getFieldName();
                            this.fixFieldNameInStack();
                            return;
                        }
                        if (this.currentNode.hasBuffer()) {
                            MCFContext m = this.stackOfContext.pop();
                            this.context = m.context;
                            this.rowBuf = this.currentNode.getBuffer();
                            if (!this.currentNode.isRoot()) {
                                this.nextEvent = m.lastEvent;
                                --this.mapLevel;
                            }
                        }
                    }
                }
            }
            if (this.replaceTopMapFieldName) {
                this.fieldName = this.currentNode.getFieldName();
                this.fixFieldNameInStack();
                this.replaceTopMapFieldName = false;
            }
        } else {
            MCFTree.Node child = this.childrenToVisit();
            if (child != null) {
                this.currentNode = child;
                if (child.hasBuffer()) {
                    this.moveToChildNode(null, false, true);
                } else {
                    child = this.childrenToVisit();
                    this.currentEvent = DocumentReader.EventType.START_MAP;
                }
                this.fieldName = this.currentNode.getFieldName();
                return;
            }
            this.moveToParentNode();
            if (this.currentNode != null) {
                if (this.currentNode.hasBuffer()) {
                    MCFContext m = this.stackOfContext.pop();
                    this.context = m.context;
                    this.rowBuf = this.currentNode.getBuffer();
                    if (this.currentNode.isSubtreeVisited()) {
                        this.currentEvent = m.lastEvent;
                        return;
                    }
                }
            } else {
                this.doneWithAll = true;
            }
            this.dfsVisit();
        }
    }

    private void getNextType() {
        this.updateCurrentContainer();
        KeyValueDeserializeHelper.deserializeWithoutKeyValue(this.context, this.rowBuf);
        Value.Type t = this.context.getType();
        if (t == null) {
            ContainerContext lastContainer = this.containerStack.pop();
            if (lastContainer.isMap()) {
                this.currentEvent = DocumentReader.EventType.END_MAP;
                this.fieldName = lastContainer.getFieldName();
            } else {
                this.currentEvent = DocumentReader.EventType.END_ARRAY;
            }
            if (!this.containerStack.isEmpty()) {
                this.context.setIsArrayElement(!this.containerStack.peek().isMap());
            }
            this.updateCurrentContainer();
            return;
        }
        this.keyValueSize = this.context.getKeyValueSize();
        this.currentEvent = Types.getEventTypeForType((Value.Type)t);
        if (this.inMap()) {
            this.fieldName = Bytes.toString((ByteBuffer)this.rowBuf, (int)this.keyValueSize[0]);
        } else if (this.context.isAbsoluteIndex()) {
            this.currentContainer.setIndex(this.context.getArrayIndex());
        } else {
            this.currentContainer.incrementIndex();
        }
        if (t == Value.Type.MAP) {
            this.context.setIsArrayElement(false);
            ++this.mapLevel;
            this.containerStack.push(new ContainerContext(Value.Type.MAP, this.fieldName));
        } else if (t == Value.Type.ARRAY) {
            this.context.setIsArrayElement(true);
            this.containerStack.push(new ContainerContext(Value.Type.ARRAY));
        }
    }

    private void cacheBigDecimalComponents() {
        byte sizeDesc = this.rowBuf.get();
        int unscaledValueSize = BigDecimalSizeDescriptor.getBigDecimalUnscaledValueSize(sizeDesc, this.rowBuf);
        this.decimalPrecision = BigDecimalSizeDescriptor.getBigDecimalPrecision(sizeDesc, this.rowBuf);
        this.decimalScale = BigDecimalSizeDescriptor.getBigDecimalScale(sizeDesc, this.rowBuf);
        this.decimalUnscaledValue = BigDecimalSizeDescriptor.getBigDecimalUnscaledValue(unscaledValueSize, this.rowBuf);
    }

    private void cacheCurrentValue(DocumentReader.EventType eventType) {
        this.processedEvent = eventType;
        switch (eventType) {
            case BOOLEAN: {
                this.currentLongValue = this.keyValueSize[1];
                break;
            }
            case STRING: {
                this.currentObjValue = Bytes.toString((ByteBuffer)this.rowBuf, (int)this.keyValueSize[1]);
                break;
            }
            case BYTE: {
                this.currentLongValue = this.rowBuf.get();
                break;
            }
            case SHORT: {
                this.currentLongValue = this.rowBuf.getShort();
                break;
            }
            case FLOAT: 
            case INT: {
                this.currentLongValue = this.rowBuf.getInt();
                break;
            }
            case DOUBLE: 
            case LONG: {
                this.currentLongValue = this.rowBuf.getLong();
                break;
            }
            case DECIMAL: {
                this.cacheBigDecimalComponents();
                this.currentObjValue = null;
                break;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INTERVAL: {
                this.currentLongValue = KeyValueDeserializeHelper.deserializeVarLong(this.keyValueSize[1], this.rowBuf);
                break;
            }
            case BINARY: {
                byte[] bytes = new byte[this.keyValueSize[1]];
                this.rowBuf.get(bytes);
                ByteBuffer b = ByteBuffer.wrap(bytes);
                this.currentObjValue = b;
                break;
            }
        }
    }

    private boolean hasNextBuffer() {
        if (this.dataMapIterator.hasNext()) {
            this.rowBuf = this.dataMapIterator.next().getValue();
            return true;
        }
        return false;
    }

    public DocumentReader.EventType next() {
        if (this.rowBuf == null && !this.hasNextBuffer()) {
            return null;
        }
        if (this.currentEvent == null) {
            if (this.emitId) {
                DocumentReader.EventType et;
                this.fieldName = "_id";
                this.processedEvent = et = Types.getEventTypeForType((Value.Type)this.idValue.getType());
                this.currentObjValue = this.idValue.getObject();
                this.emitId = false;
                return et;
            }
            if (this.nextEvent != null) {
                this.currentEvent = this.nextEvent;
                this.nextEvent = null;
            } else {
                this.dfsVisit();
            }
        }
        DocumentReader.EventType et = this.currentEvent;
        this.currentEvent = null;
        if (et != null) {
            this.cacheCurrentValue(et);
        }
        return et;
    }

    private void updateCurrentContainer() {
        this.currentContainer = this.containerStack.isEmpty() ? null : this.containerStack.peek();
    }

    private void checkEventType(DocumentReader.EventType eventType) throws TypeException {
        if (this.processedEvent != eventType) {
            throw new TypeException("Event type mismatch");
        }
    }

    public String getFieldName() {
        if (!this.inMap()) {
            throw new IllegalStateException("Not traversing a map!");
        }
        return this.fieldName;
    }

    public byte getByte() {
        this.checkEventType(DocumentReader.EventType.BYTE);
        return (byte)this.currentLongValue;
    }

    public short getShort() {
        this.checkEventType(DocumentReader.EventType.SHORT);
        return (short)this.currentLongValue;
    }

    public long getLong() {
        this.checkEventType(DocumentReader.EventType.LONG);
        return this.currentLongValue;
    }

    public int getInt() {
        this.checkEventType(DocumentReader.EventType.INT);
        return (int)this.currentLongValue;
    }

    public float getFloat() {
        this.checkEventType(DocumentReader.EventType.FLOAT);
        return Float.intBitsToFloat((int)(this.currentLongValue & 0xFFFFFFFFL));
    }

    public double getDouble() {
        this.checkEventType(DocumentReader.EventType.DOUBLE);
        return Double.longBitsToDouble(this.currentLongValue);
    }

    public BigDecimal getDecimal() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        if (this.currentObjValue == null) {
            this.currentObjValue = new BigDecimal(new BigInteger(this.decimalUnscaledValue), this.decimalScale, new MathContext(this.decimalPrecision));
        }
        return (BigDecimal)this.currentObjValue;
    }

    public int getDecimalPrecision() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.decimalPrecision;
    }

    public int getDecimalScale() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.decimalScale;
    }

    public int getDecimalValueAsInt() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            return decimal.intValueExact();
        }
        return 0;
    }

    public long getDecimalValueAsLong() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            return decimal.longValueExact();
        }
        return 0L;
    }

    public ByteBuffer getDecimalValueAsBytes() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            BigInteger decimalInteger = decimal.unscaledValue();
            byte[] bytearray = decimalInteger.toByteArray();
            return ByteBuffer.wrap(bytearray);
        }
        return null;
    }

    public boolean getBoolean() {
        this.checkEventType(DocumentReader.EventType.BOOLEAN);
        return this.currentLongValue != 0L;
    }

    public String getString() {
        this.checkEventType(DocumentReader.EventType.STRING);
        return (String)this.currentObjValue;
    }

    public long getTimestampLong() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.currentLongValue;
    }

    public OTimestamp getTimestamp() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return new OTimestamp(this.currentLongValue);
    }

    public int getDateInt() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return (int)this.currentLongValue;
    }

    public ODate getDate() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return ODate.fromDaysSinceEpoch((int)((int)this.currentLongValue));
    }

    public int getTimeInt() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return (int)(this.currentLongValue % 86400000L);
    }

    public OTime getTime() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return OTime.fromMillisOfDay((int)((int)this.currentLongValue));
    }

    public OInterval getInterval() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return new OInterval(this.currentLongValue);
    }

    public int getIntervalDays() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return (int)(this.currentLongValue / 86400000L);
    }

    public long getIntervalMillis() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return this.currentLongValue;
    }

    public ByteBuffer getBinary() {
        this.checkEventType(DocumentReader.EventType.BINARY);
        return (ByteBuffer)this.currentObjValue;
    }

    @Override
    public ControlInfo getControlInfo() {
        if (this.processedEvent == DocumentReader.EventType.END_MAP || this.processedEvent == DocumentReader.EventType.END_ARRAY) {
            throw new UnsupportedOperationException("Can not return timeDescriptor for eventType END_MAP or END_ARRAY");
        }
        return new ControlInfoImpl(this.context.getTimeDescriptor());
    }

    @Override
    public Value getId() {
        return this.idValue;
    }

    public boolean inMap() {
        return this.currentContainer == null || this.currentContainer.isMap();
    }

    public int getArrayIndex() {
        return this.currentContainer.getIndex();
    }
}

