/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.ojai.DBDocumentReaderIterable;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.jni.MapRResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.exceptions.StreamInUseException;

public class DBDocumentStream
implements DocumentStream {
    MapRResultScanner scanner_;
    boolean excludeId_;
    MapRDBTableImpl table_;
    private volatile boolean iteratorOpened_;
    private volatile boolean closed_;
    private volatile boolean docStreamIteratorOpened_;
    Set<FieldPath> conditionPaths_;
    String[] projPaths_;

    public DBDocumentStream(MapRResultScanner scanner, boolean excludeId, MapRDBTableImpl table) {
        this.scanner_ = scanner;
        this.excludeId_ = excludeId;
        this.table_ = table;
        this.iteratorOpened_ = false;
        this.conditionPaths_ = null;
        this.projPaths_ = null;
        this.closed_ = false;
        this.docStreamIteratorOpened_ = false;
    }

    public DBDocumentStream(MapRResultScanner scanner, boolean excludeId, MapRDBTableImpl table, Set<FieldPath> condPaths, String ... projPaths) {
        this.scanner_ = scanner;
        this.excludeId_ = excludeId;
        this.table_ = table;
        this.iteratorOpened_ = false;
        this.conditionPaths_ = condPaths;
        this.projPaths_ = projPaths;
        this.closed_ = false;
        this.docStreamIteratorOpened_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamTo(DocumentListener l) {
        Exception failure = null;
        try {
            Iterator<Document> i$ = this.iterator();
            while (i$.hasNext()) {
                Document doc = i$.next();
                if (l.documentArrived(doc)) continue;
                break;
            }
        }
        catch (Exception e) {
            failure = e;
        }
        finally {
            block15: {
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (failure != null) break block15;
                    failure = e;
                }
            }
        }
        if (failure == null) {
            l.eos();
        } else {
            l.failed(failure);
        }
    }

    public synchronized void close() {
        if (!this.closed_) {
            this.scanner_.close();
            this.closed_ = true;
        }
    }

    private Document next() throws IOException {
        MapRResult res = null;
        try {
            res = this.scanner_.nextRow();
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "findAll.next()");
        }
        ByteBuffer keyBuf = res.getKey();
        if (keyBuf == null) {
            return null;
        }
        Map cfbufs = res.getJsonByteBufs();
        if (cfbufs == null) {
            return null;
        }
        boolean shouldPrunePaths = this.conditionPaths_ != null && this.conditionPaths_.size() != 0;
        DBDocumentImpl doc = RowcolCodec.decode(cfbufs, this.table_.sortedByPath(), this.table_.idToCFNameMap(), keyBuf, this.excludeId_, true, this.table_.isKeepInsertionOrder(), this.table_.decodeTimestamp(), false, shouldPrunePaths ? this.projPaths_ : null);
        if (shouldPrunePaths) {
            doc.getDOMFromCachedBuffer();
            if (doc.size() == 0) {
                return this.next();
            }
        }
        return doc;
    }

    public void makeIteratorNotOpen() {
        this.docStreamIteratorOpened_ = false;
    }

    private void checkDocStreamIteratorOpened() {
        if (this.docStreamIteratorOpened_) {
            throw new StreamInUseException("An iterator has already been opened on this document stream.");
        }
    }

    private synchronized void checkDocStreamClosed() {
        if (this.closed_) {
            throw new IllegalStateException("DocumentStream already closed.");
        }
    }

    public Iterator<Document> iterator() {
        this.checkDocStreamIteratorOpened();
        this.checkDocStreamClosed();
        this.docStreamIteratorOpened_ = true;
        return new Iterator<Document>(){
            Document next = null;
            boolean done = false;

            @Override
            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                DBDocumentStream.this.checkDocStreamClosed();
                if (this.next == null) {
                    try {
                        this.next = DBDocumentStream.this.next();
                        if (this.next == null) {
                            this.done = true;
                            try {
                                DBDocumentStream.this.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw ExceptionHandler.handle(e, "findNext()");
                    }
                }
                return true;
            }

            @Override
            public Document next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called after hasNext() returned false.");
                }
                Document temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<DocumentReader> documentReaders() {
        this.checkStateForIteration();
        this.iteratorOpened_ = true;
        return new DBDocumentReaderIterable(this);
    }

    private void checkStateForIteration() {
        if (this.iteratorOpened_) {
            throw new StreamInUseException("An iterator has already been opened on this document stream.");
        }
    }
}

