/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.codec;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.mapr.db.spark.codec.JacksonBeanCodecHelper;
import org.ojai.annotation.API;
import org.ojai.beans.jackson.JacksonHelper;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public final class JacksonBeanCodecHelper$ {
    public static final JacksonBeanCodecHelper$ MODULE$;
    private Version VERSION;
    private final ObjectMapper MAPPER;
    private final String version;
    private final String version_str;
    private final SimpleModule module;
    private final JacksonBeanCodecHelper.ByteSerializer byteSerializer;

    static {
        new JacksonBeanCodecHelper$();
    }

    public Version VERSION() {
        return this.VERSION;
    }

    public void VERSION_$eq(Version x$1) {
        this.VERSION = x$1;
    }

    public ObjectMapper MAPPER() {
        return this.MAPPER;
    }

    public String version() {
        return this.version;
    }

    public String version_str() {
        return this.version_str;
    }

    public SimpleModule module() {
        return this.module;
    }

    public JacksonBeanCodecHelper.ByteSerializer byteSerializer() {
        return this.byteSerializer;
    }

    private JacksonBeanCodecHelper$() {
        MODULE$ = this;
        this.VERSION = null;
        this.MAPPER = new ObjectMapper();
        this.version = JacksonHelper.class.getPackage().getImplementationVersion();
        this.version_str = this.version() == null ? "<unknown>" : this.version();
        this.VERSION_$eq(VersionUtil.parseVersion((String)this.version_str(), (String)"org.ojai", (String)"core"));
        this.module = new SimpleModule("OjaiSerializers", this.VERSION());
        this.byteSerializer = new JacksonBeanCodecHelper.ByteSerializer();
        this.module().addSerializer(Byte.TYPE, (JsonSerializer)this.byteSerializer());
        this.module().addSerializer(OInterval.class, (JsonSerializer)new JacksonHelper.IntervalSerializer());
        this.module().addDeserializer(OInterval.class, (JsonDeserializer)new JacksonHelper.IntervalDeserializer());
        this.module().addSerializer(ODate.class, (JsonSerializer)new JacksonHelper.DateSerializer());
        this.module().addDeserializer(ODate.class, (JsonDeserializer)new JacksonHelper.DateDeserializer());
        this.module().addSerializer(OTime.class, (JsonSerializer)new JacksonHelper.TimeSerializer());
        this.module().addDeserializer(OTime.class, (JsonDeserializer)new JacksonHelper.TimeDeserializer());
        this.module().addSerializer(OTimestamp.class, (JsonSerializer)new JacksonHelper.TimestampSerializer());
        this.module().addDeserializer(OTimestamp.class, (JsonDeserializer)new JacksonHelper.TimestampDeserializer());
        this.MAPPER().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.MAPPER().registerModule((Module)this.module());
    }
}

