/*
 * Decompiled with CFR 0.152.
 */
package app.utils.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfig {
    private static AppConfig instance;
    private static List<String> sourceFileLocations;
    private CompositeConfiguration configs = new CompositeConfiguration();
    private static Properties contextParamsOverride;
    private static Logger LOG;

    static {
        sourceFileLocations = List.of("config/application.properties");
        contextParamsOverride = new Properties();
        LOG = LoggerFactory.getLogger(AppConfig.class);
    }

    private AppConfig() throws ConfigurationException {
        this.configs.addConfiguration((Configuration)new SystemConfiguration());
        this.configs.addConfiguration((Configuration)new EnvironmentConfiguration());
        if (sourceFileLocations != null) {
            sourceFileLocations.forEach(sourceFileLocation -> AppConfig.addConfigsFromFile(this.configs, sourceFileLocation));
        }
    }

    public static void addConfigsFromFile(CompositeConfiguration configs, String sourceFileLocation) {
        try {
            Path filePath = Path.of(sourceFileLocation, new String[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                configs.addConfiguration((Configuration)new Configurations().properties(filePath.toFile()));
            } else {
                InputStream resourceAsStream = AppConfig.class.getClassLoader().getResourceAsStream(sourceFileLocation);
                if (resourceAsStream != null) {
                    Properties properties = new Properties();
                    properties.load(resourceAsStream);
                    for (String key : properties.stringPropertyNames()) {
                        String value = properties.getProperty(key);
                        configs.addProperty(key, (Object)value);
                    }
                } else {
                    LOG.error("Failed to read properties from file '{}", (Object)sourceFileLocation);
                }
            }
        }
        catch (IOException | ConfigurationException e) {
            LOG.error("Failed to retrieve configs from file '{}'", (Object)sourceFileLocation, (Object)e);
        }
    }

    public static void setConfigFileLocation(String ... fileLocations) {
        sourceFileLocations = fileLocations != null && fileLocations.length > 0 ? List.of(fileLocations) : null;
    }

    public static void addContextParamProperty(Object key, Object value) {
        contextParamsOverride.put(key, value);
    }

    public static Properties getContextParamsOverride() {
        return contextParamsOverride;
    }

    public static AppConfig getInstance() {
        if (instance == null) {
            try {
                instance = new AppConfig();
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Failed to initialize AppConfig singleton instance", e);
            }
        }
        return instance;
    }

    public static void reload() {
        instance = null;
        AppConfig.getInstance();
    }

    public CompositeConfiguration getConfigs() {
        return this.configs;
    }

    public String getConfig(String name) {
        return AppConfig.getInstance().getConfigs().getString(name);
    }

    public int getIntConfig(String name) {
        return AppConfig.getInstance().getConfigs().getInt(name);
    }

    public int getIntConfig(String name, int defaultValue) {
        return AppConfig.getInstance().getConfigs().getInt(name, defaultValue);
    }

    public String getServerConfigAddress(String endpointFromContextFile) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(endpointFromContextFile);
        uriBuilder.setScheme(AppConfig.getInstance().getConfig("server.protocol"));
        uriBuilder.setHost(AppConfig.getInstance().getConfig("server.host"));
        uriBuilder.setPort(AppConfig.getInstance().getIntConfig("server.port"));
        return uriBuilder.build().toString();
    }

    public URI getServerConfigURI(String endpointFromContextFile) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(endpointFromContextFile);
        uriBuilder.setScheme(AppConfig.getInstance().getConfig("server.protocol"));
        uriBuilder.setHost(AppConfig.getInstance().getConfig("server.host"));
        uriBuilder.setPort(AppConfig.getInstance().getIntConfig("server.port"));
        return uriBuilder.build();
    }
}

