/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server.security.legacy.oidc;

import app.utils.server.security.legacy.oidc.OidcClientUtils;
import app.utils.server.security.legacy.oidc.OidcConfiguration;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenAuthenticator
extends LoginAuthenticator {
    private static Logger LOG = LoggerFactory.getLogger(OidcAccessTokenAuthenticator.class);
    private OidcConfiguration oidcConfiguration;

    public OidcAccessTokenAuthenticator(Map<String, String> oidcSettings) {
        new OidcClientUtils(oidcSettings);
        this.oidcConfiguration = OidcClientUtils.getOidcConfiguration();
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        String accessToken;
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty() && this.verifyAccessToken(accessToken)) {
            DefaultUserIdentity user = new DefaultUserIdentity(null, null, new String[]{"user"});
            return new UserAuthentication(this.getAuthMethod(), (UserIdentity)user);
        }
        return Authentication.UNAUTHENTICATED;
    }

    private boolean verifyAccessToken(String accessToken) {
        String validationEndpoint = this.oidcConfiguration.getValidationEndpoint();
        HttpURLConnection connection = null;
        try {
            if (validationEndpoint == null || validationEndpoint.isEmpty()) {
                throw new RuntimeException("Location of Oidc validation endpoint is not set");
            }
            connection = (HttpURLConnection)new URL(validationEndpoint).openConnection();
            String postBody = String.format("token=%s&token_type_hint=access_token", URLEncoder.encode(accessToken, "UTF-8"));
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream os = connection.getOutputStream();){
                os.write(postBody.getBytes("UTF-8"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String responseContent = new BufferedReader(new InputStreamReader(connection.getInputStream())).lines().collect(Collectors.joining());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(responseContent.getBytes(StandardCharsets.UTF_8));
            Map<String, String> map = OidcClientUtils.parseJson(inputStream);
            String active = map.get("active");
            if (active != null && active.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (IOException e) {
            LOG.error("Something else than the token validity has gone wrong", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    public String getAuthMethod() {
        return "OAUTH";
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

