/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server.security.legacy.oidc;

import app.utils.server.security.legacy.oidc.OidcClientUtils;
import app.utils.server.security.legacy.oidc.OidcConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(OidcAccessTokenFilter.class);
    private OidcConfiguration oidcConfiguration;
    private HttpClient httpClient;

    public OidcAccessTokenFilter(Map<String, String> oidcSettings) {
        new OidcClientUtils(oidcSettings);
        this.oidcConfiguration = OidcClientUtils.getOidcConfiguration();
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String accessToken;
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty() && this.verifyAccessToken(accessToken)) {
            chain.doFilter((ServletRequest)request, response);
            return;
        }
        HttpServletResponse httpResp = (HttpServletResponse)response;
        httpResp.setHeader("WWW-Authenticate", "Bearer");
        httpResp.sendError(401, "Unauthorized");
    }

    private boolean verifyAccessToken(String accessToken) throws IOException {
        String validationEndpoint = this.oidcConfiguration.getValidationEndpoint();
        try {
            if (validationEndpoint == null || validationEndpoint.isEmpty()) {
                throw new RuntimeException("Location of Oidc validation endpoint is not set");
            }
            String postBody = String.format("token=%s&token_type_hint=access_token", URLEncoder.encode(accessToken, "UTF-8"));
            StringContentProvider content = new StringContentProvider(postBody, StandardCharsets.UTF_8);
            ContentResponse oidcProviderResponse = this.httpClient.newRequest(validationEndpoint).method(HttpMethod.POST).content((ContentProvider)content, "application/x-www-form-urlencoded").send();
            String responseContent = oidcProviderResponse.getContentAsString();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(responseContent.getBytes(StandardCharsets.UTF_8));
            Map<String, String> map = OidcClientUtils.parseJson(inputStream);
            String active = map.get("active");
            if (active != null && active.equalsIgnoreCase("true")) {
                return true;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Something else than the token validity has gone wrong", (Throwable)e);
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.httpClient = new HttpClient();
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        if (this.httpClient != null) {
            try {
                this.httpClient.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

