/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server.security.legacy.oidc;

import app.utils.server.security.legacy.oidc.OidcConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cxf.helpers.IOUtils;

public class OidcClientUtils {
    private static OidcConfiguration oidcConfiguration = new OidcConfiguration();

    public OidcClientUtils(Map<String, String> oidcProperties) {
        oidcConfiguration = new OidcConfiguration(oidcProperties);
    }

    public OidcClientUtils(OidcConfiguration oidcConfiguration) {
        OidcClientUtils.oidcConfiguration = oidcConfiguration;
    }

    public static String getValidationEndpoint() {
        return oidcConfiguration.getValidationEndpoint();
    }

    public static OidcConfiguration getOidcConfiguration() {
        return oidcConfiguration;
    }

    public static Map<String, String> parseJson(InputStream is) throws IOException {
        String str = IOUtils.readStringFromStream((InputStream)is).trim();
        if (str.length() == 0) {
            return Collections.emptyMap();
        }
        if (!str.startsWith("{") || !str.endsWith("}")) {
            throw new IOException("JSON Sequence is broken: " + str);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        str = str.substring(1, str.length() - 1).trim();
        String[] jsonPairs = str.split(",");
        int i = 0;
        while (i < jsonPairs.length) {
            String pair = jsonPairs[i].trim();
            if (pair.length() != 0) {
                String value;
                int index = pair.indexOf(":");
                String key = pair.substring(0, index).trim();
                if (key.startsWith("\"") && key.endsWith("\"")) {
                    key = key.substring(1, key.length() - 1);
                }
                if ((value = pair.substring(index + 1).trim()).startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                map.put(key, value);
            }
            ++i;
        }
        return map;
    }
}

