/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdCredentials;
import org.eclipse.jetty.security.openid.OpenIdLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdLoginWithRoleExtractionService
extends OpenIdLoginService {
    private static Logger LOG = LoggerFactory.getLogger(OpenIdLoginService.class);

    public OpenIdLoginWithRoleExtractionService(OpenIdConfiguration configuration) {
        super(configuration);
    }

    public UserIdentity login(String identifier, Object credentials, ServletRequest req) {
        UserIdentity user = super.login(identifier, credentials, req);
        String[] roles = new String[]{};
        try {
            roles = this.extractRoles((OpenIdCredentials)credentials);
        }
        catch (Exception e) {
            LOG.error("Authentication will fail, 'roles' Json node not found in JWT received by the OpenId provider");
        }
        return super.getIdentityService().newUserIdentity(user.getSubject(), user.getUserPrincipal(), roles);
    }

    private String[] extractRoles(OpenIdCredentials credentials) {
        Object[] rolesAsArrObj = (Object[])credentials.getClaims().get("roles");
        String[] result = new String[rolesAsArrObj.length];
        for (int i = 0; i < rolesAsArrObj.length; ++i) {
            result[i] = (String)rolesAsArrObj[i];
            LOG.info("extractRoles - Found role '{}' in JWT", rolesAsArrObj[i]);
        }
        return result;
    }
}

