/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.oauth;

import app.utils.config.AppConfig;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAccessTokenFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAccessTokenFilter.class);
    private final JwkProvider jwkProvider;

    public JwtAccessTokenFilter() {
        try {
            URI uri = new URI(AppConfig.getInstance().getConfigs().getString("oauth.provider.jwks.endpoint"));
            URL url = uri.toURL();
            this.jwkProvider = new JwkProviderBuilder(url).cached(true).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String accessToken;
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty() && this.verifyJWTAccessToken(request, accessToken)) {
            chain.doFilter((ServletRequest)request, response);
            return;
        }
        HttpServletResponse httpResp = (HttpServletResponse)response;
        httpResp.setHeader("WWW-Authenticate", "Bearer");
        httpResp.sendError(401, "Unauthorized");
    }

    private boolean verifyJWTAccessToken(HttpServletRequest request, String accessToken) {
        try {
            DecodedJWT decodedJwt = JWT.decode((String)accessToken);
            String kid = decodedJwt.getKeyId();
            String algorithmName = decodedJwt.getAlgorithm();
            Algorithm algorithm = this.getAlgorithm(kid, algorithmName);
            String requestPath = request.getRequestURL().toString();
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withAudience(new String[]{requestPath}).build();
            verifier.verify(decodedJwt);
            LOG.debug("Access Token with algorithm {} is valid", (Object)algorithmName);
            return true;
        }
        catch (JwkException e) {
            LOG.error("Unable to get Access Token signature Public Key from provider", (Throwable)e);
        }
        catch (JWTVerificationException e) {
            LOG.error("Access Token is not valid", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("An unexpected error occurred during Access Token validation", (Throwable)e);
        }
        return false;
    }

    private Algorithm getAlgorithm(String kid, String algorithmName) throws JwkException, JWTVerificationException {
        switch (algorithmName) {
            case "RS256": {
                return Algorithm.RSA256((RSAPublicKey)this.getRSAPublicKey(kid), null);
            }
            case "RS384": {
                return Algorithm.RSA384((RSAPublicKey)this.getRSAPublicKey(kid), null);
            }
            case "RS512": {
                return Algorithm.RSA512((RSAPublicKey)this.getRSAPublicKey(kid), null);
            }
        }
        throw new JWTVerificationException("Unsupported algorithm: " + algorithmName);
    }

    private RSAPublicKey getRSAPublicKey(String kid) throws JwkException {
        Jwk jwk = this.jwkProvider.get(kid);
        return (RSAPublicKey)jwk.getPublicKey();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

