/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import app.utils.config.AppConfig;
import app.utils.security.server.NoOpLoginService;
import app.utils.security.server.OpenIdLoginWithRoleExtractionService;
import app.utils.security.server.legacy.oidc.OidcAccessTokenAuthenticator;
import app.utils.security.server.legacy.oidc.OidcAccessTokenFilter;
import app.utils.security.server.oauth.JwtAccessTokenAuthenticator;
import app.utils.security.server.oauth.JwtAccessTokenFilter;
import app.utils.server.ServletResourceManager;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.system.DiskSpaceMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.jmx.BuildInfoCollector;
import io.prometheus.jmx.JmxCollector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.UUID;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParametersConfig;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.TLSServerParametersType;
import org.apache.cxf.jaxrs.provider.dom4j.DOM4JProvider;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.openid.OpenIdAuthenticator;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jolokia.http.AgentServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppJetty {
    private static final Logger LOG = LoggerFactory.getLogger(AppJetty.class);

    public static CompositeConfiguration cfg() {
        return AppConfig.getInstance().getConfigs();
    }

    public static Server createServer() {
        int webPort = AppJetty.cfg().getInt("server.port", 8065);
        return new Server(webPort);
    }

    public static void addCxfJaxRSServlet(ServletContextHandler servletContext, String applicationClassName) {
        ServletHolder cxfServletHolder = new ServletHolder((Servlet)new CXFNonSpringJaxrsServlet());
        cxfServletHolder.setInitParameter("jaxrs.serviceClasses", applicationClassName);
        cxfServletHolder.setInitParameter("jaxrs.providers", DOM4JProvider.class.getName());
        servletContext.addServlet(cxfServletHolder, "/services/*");
    }

    public static JettyHTTPServerEngine createServer(Bus cxfBus) throws GeneralSecurityException, IOException {
        JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)cxfBus.getExtension(JettyHTTPServerEngineFactory.class);
        TLSServerParametersConfig params = AppJetty.getTLSConfig();
        if (params != null) {
            serverEngineFactory.setTLSServerParametersForPort("localhost", AppJetty.cfg().getInt("server.port"), (TLSServerParameters)params);
        }
        return serverEngineFactory.createJettyHTTPServerEngine(AppJetty.cfg().getString("server.host"), AppJetty.cfg().getInt("server.port"), AppJetty.cfg().getString("server.protocol"));
    }

    private static String getMgmtContextPath(ServletContextHandler servletContext) {
        return servletContext.getContextPath().length() > 1 ? "" : AppJetty.cfg().getString("server.management.base-path");
    }

    public static void addJolokiaServlet(ServletContextHandler servletContext) {
        ServletHolder servletHolder = new ServletHolder("jolokia", AgentServlet.class);
        servletContext.addServlet(servletHolder, String.format("%s/jolokia/*", AppJetty.getMgmtContextPath(servletContext)));
    }

    public static void addPrometheusServlet(ServletContextHandler servletContext) {
        CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;
        PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT, collectorRegistry, Clock.SYSTEM);
        new UptimeMetrics().bindTo((MeterRegistry)meterRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)meterRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)meterRegistry);
        new DiskSpaceMetrics(new File(".")).bindTo((MeterRegistry)meterRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)meterRegistry);
        new ClassLoaderMetrics().bindTo((MeterRegistry)meterRegistry);
        JvmGcMetrics jvmGcMetrics = new JvmGcMetrics();
        jvmGcMetrics.bindTo((MeterRegistry)meterRegistry);
        JvmHeapPressureMetrics jvmHeapPressureMetrics = new JvmHeapPressureMetrics();
        jvmHeapPressureMetrics.bindTo((MeterRegistry)meterRegistry);
        Log4j2Metrics log4j2Metrics = new Log4j2Metrics();
        log4j2Metrics.bindTo((MeterRegistry)meterRegistry);
        new JettyConnectionMetrics((MeterRegistry)meterRegistry);
        new JettySslHandshakeMetrics((MeterRegistry)meterRegistry);
        new BuildInfoCollector().register(collectorRegistry);
        String sourceFileLocation = "config/jmx-prometheus.yaml";
        try (InputStream resourceAsStream = AppJetty.class.getClassLoader().getResourceAsStream(sourceFileLocation);){
            if (resourceAsStream != null) {
                new JmxCollector(resourceAsStream).register(collectorRegistry);
            } else {
                LOG.error("Failed to load file " + sourceFileLocation + ", Prometheus JMX metrics collector will not be registered");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize Prometheus JMX metrics collector", (Throwable)e);
        }
        ServletResourceManager resourceManager = new ServletResourceManager(new AutoCloseable[]{jvmGcMetrics, jvmHeapPressureMetrics, log4j2Metrics});
        servletContext.addEventListener((EventListener)((Object)resourceManager));
        ServletHolder prometheusHolder = new ServletHolder("prometheus", (Servlet)new MetricsServlet(meterRegistry.getPrometheusRegistry()));
        servletContext.addServlet(prometheusHolder, String.format("%s/prometheus", AppJetty.getMgmtContextPath(servletContext)));
    }

    public static void addHealthCheck(ServletContextHandler servletContext, HttpServlet servlet) {
        ServletHolder liveServletHolder = new ServletHolder((Servlet)servlet);
        servletContext.addServlet(liveServletHolder, String.format("%s/health", AppJetty.getMgmtContextPath(servletContext)));
    }

    public static void addCamelHealthCheck(ServletContextHandler servletContext, HttpServlet servlet) {
        ServletHolder readyServletHolder = new ServletHolder((Servlet)servlet);
        servletContext.addServlet(readyServletHolder, String.format("%s/ready", AppJetty.getMgmtContextPath(servletContext)));
    }

    public static void addInfoEndpoint(ServletContextHandler servletContext, HttpServlet servlet) {
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletContext.addServlet(servletHolder, String.format("%s/info", AppJetty.getMgmtContextPath(servletContext)));
    }

    public static void addShutdownEndpoint(ServletContextHandler servletContext, HttpServlet servlet) {
        ServletHolder shutdownHolder = new ServletHolder((Servlet)servlet);
        servletContext.addServlet(shutdownHolder, String.format("%s/shutdown", AppJetty.getMgmtContextPath(servletContext)));
    }

    public static void addJmxManagement(Bus cxfBus) {
        InstrumentationManagerImpl im = new InstrumentationManagerImpl(cxfBus);
        im.setUsePlatformMBeanServer(Boolean.valueOf(true));
        im.getMBeanServer();
        im.setBus(cxfBus);
        im.setEnabled(true);
        im.init();
        CounterRepository cxfCounter = new CounterRepository();
        cxfCounter.setBus(cxfBus);
    }

    public static void addCrossOriginFilter(ServletContextHandler servletContext) {
        FilterHolder holder = new FilterHolder(CrossOriginFilter.class);
        holder.setName("cross-origin");
        servletContext.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addBasicAuthentication(ServletContextHandler servletContext, String constraintPath) {
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(constraintPath);
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        BasicAuthenticator authenticator = new BasicAuthenticator();
        servletContext.setSecurityHandler((SecurityHandler)security);
        String realmName = "TalendRealm";
        security.setRealmName(realmName);
        security.setAuthenticator((Authenticator)authenticator);
        UserStore userStore = new UserStore();
        userStore.addUser(AppJetty.cfg().getString("security.user.name"), (Credential)new Password(AppJetty.cfg().getString("security.user.password")), new String[]{"user"});
        HashLoginService loginService = new HashLoginService();
        loginService.setName(realmName);
        loginService.setUserStore(userStore);
        security.setLoginService((LoginService)loginService);
    }

    public static void addLegacyOIDCViaFilter(ServletContextHandler servletContext, String constraintPath) {
        OidcAccessTokenFilter filter = new OidcAccessTokenFilter(AppJetty.cfg().getString("validation.endpoint"));
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        servletContext.addFilter(filterHolder, constraintPath, EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addLegacyOIDCViaAuthenticator(ServletContextHandler servletContext, String constraintPath) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("OAUTH");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(constraintPath);
        mapping.setConstraint(constraint);
        securityHandler.setConstraintMappings(Collections.singletonList(mapping));
        OidcAccessTokenAuthenticator authenticator = new OidcAccessTokenAuthenticator(AppJetty.cfg().getString("validation.endpoint"));
        securityHandler.setAuthenticator((Authenticator)authenticator);
        NoOpLoginService loginService = new NoOpLoginService();
        securityHandler.setLoginService((LoginService)loginService);
        servletContext.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public static void addJWTAuthorizationViaFilter(ServletContextHandler servletContext, String constraintPath) {
        JwtAccessTokenFilter filter = new JwtAccessTokenFilter();
        FilterHolder filterHolder = new FilterHolder((Filter)filter);
        servletContext.addFilter(filterHolder, constraintPath, EnumSet.of(DispatcherType.REQUEST));
    }

    public static void addJWTAuthorizationViaAuthenticator(ServletContextHandler servletContext, String constraintPath) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("OAUTH");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(constraintPath);
        mapping.setConstraint(constraint);
        securityHandler.setConstraintMappings(Collections.singletonList(mapping));
        JwtAccessTokenAuthenticator authenticator = new JwtAccessTokenAuthenticator();
        securityHandler.setAuthenticator((Authenticator)authenticator);
        NoOpLoginService loginService = new NoOpLoginService();
        securityHandler.setLoginService((LoginService)loginService);
        servletContext.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public static void addOIDAuthorizationCodeFlow(ServletContextHandler servletContext, String constraintPath) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setRealmName("TalendRealm");
        Constraint constraint = new Constraint();
        constraint.setName("OPENID");
        constraint.setRoles(new String[]{"TalendRealmRole"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(constraintPath);
        mapping.setConstraint(constraint);
        securityHandler.setConstraintMappings(Collections.singletonList(mapping));
        OpenIdConfiguration openIdConfig = new OpenIdConfiguration(AppJetty.cfg().getString("oidc.auth.provider.realm.url"), AppJetty.cfg().getString("oidc.auth.client.id"), AppJetty.cfg().getString("oidc.auth.client.secret"));
        LOG.info(String.format("Will authenticate with OpenId Provider using %s method", openIdConfig.getAuthMethod()));
        OpenIdLoginWithRoleExtractionService openIdLoginService = new OpenIdLoginWithRoleExtractionService(openIdConfig);
        securityHandler.setLoginService((LoginService)openIdLoginService);
        OpenIdAuthenticator authenticator = new OpenIdAuthenticator();
        securityHandler.setAuthenticator((Authenticator)authenticator);
        servletContext.setSecurityHandler((SecurityHandler)securityHandler);
        SessionHandler sessionHandler = new SessionHandler();
        DefaultSessionCache sessionCache = new DefaultSessionCache(sessionHandler);
        NullSessionDataStore nullDataStore = new NullSessionDataStore();
        sessionCache.setSessionDataStore((SessionDataStore)nullDataStore);
        sessionHandler.setSessionCache((SessionCache)sessionCache);
        servletContext.setSessionHandler(sessionHandler);
    }

    private static TLSServerParametersConfig getTLSConfig() throws IOException, GeneralSecurityException {
        if (AppJetty.cfg().getBoolean("security.require-ssl", false)) {
            TLSServerParametersType tlsServerParameters = new TLSServerParametersType();
            tlsServerParameters.setCertAlias(AppJetty.cfg().getString("server.ssl.key-store-alias"));
            ClientAuthentication cau = new ClientAuthentication();
            cau.setRequired(Boolean.valueOf(false));
            cau.setWant(Boolean.valueOf(false));
            tlsServerParameters.setClientAuthentication(cau);
            KeyManagersType kmt = new KeyManagersType();
            KeyStoreType kst = new KeyStoreType();
            kst.setFile(Paths.get(AppJetty.cfg().getString("server.ssl.key-store"), new String[0]).toAbsolutePath().toString());
            kst.setPassword(AppJetty.cfg().getString("server.ssl.key-store-password"));
            kst.setType(AppJetty.cfg().getString("server.ssl.key-store-type"));
            kmt.setKeyStore(kst);
            kmt.setKeyPassword(AppJetty.cfg().getString("server.ssl.key-store-password"));
            tlsServerParameters.setKeyManagers(kmt);
            return new TLSServerParametersConfig(tlsServerParameters);
        }
        return null;
    }

    public static void addSSLSupport(Server server) {
        if (AppJetty.cfg().getBoolean("security.require-ssl", false)) {
            HttpConfiguration https_config = new HttpConfiguration();
            https_config.setSecureScheme("https");
            https_config.setSecurePort(AppJetty.cfg().getInt("server.port"));
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            https_config.addCustomizer((HttpConfiguration.Customizer)src);
            File keystoreFile = Paths.get(AppJetty.cfg().getString("server.ssl.key-store"), new String[0]).toFile();
            if (!keystoreFile.exists()) {
                throw new RuntimeException("Could not setup keystore {} file not found" + keystoreFile.getAbsolutePath());
            }
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword(AppJetty.cfg().getString("server.ssl.key-store-password"));
            sslContextFactory.setKeyStoreType(AppJetty.cfg().getString("server.ssl.key-store-type"));
            sslContextFactory.setCertAlias(AppJetty.cfg().getString("server.ssl.key-store-alias"));
            try {
                sslContextFactory.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
            https.setPort(AppJetty.cfg().getInt("server.port"));
            https.setHost(AppJetty.cfg().getString("server.host"));
            server.setConnectors(new Connector[]{https});
        }
    }

    public static SSLContextParameters buildSSLContext() {
        CompositeConfiguration cfg = AppConfig.getInstance().getConfigs();
        if (cfg.getBoolean("security.require-ssl", false)) {
            KeyStoreParameters keyStoreParameters = new KeyStoreParameters();
            keyStoreParameters.setResource(cfg.getString("server.ssl.key-store"));
            keyStoreParameters.setPassword(cfg.getString("server.ssl.key-store-password"));
            KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
            keyManagersParameters.setKeyStore(keyStoreParameters);
            SSLContextParameters sslContextParameters = new SSLContextParameters();
            sslContextParameters.setKeyManagers(keyManagersParameters);
            sslContextParameters.setCertAlias(cfg.getString("server.ssl.key-store-alias"));
            return sslContextParameters;
        }
        return null;
    }

    public static void generateUserNameAndPassword() {
        String currentPassword;
        String currentUser = AppConfig.getInstance().getConfig("security.user.name");
        boolean doReload = false;
        if (StringUtils.isEmpty((CharSequence)currentUser)) {
            currentUser = "user";
            System.setProperty("security.user.name", currentUser);
            doReload = true;
            LOG.warn("username is not available, generating");
        }
        if (StringUtils.isEmpty((CharSequence)(currentPassword = AppConfig.getInstance().getConfig("security.user.password")))) {
            currentPassword = UUID.randomUUID().toString();
            System.setProperty("security.user.password", currentPassword);
            doReload = true;
            LOG.warn("password is not available, generating");
            LOG.warn(String.format("%n%nUsing generated security credentials %nusername: %s %npassword: %s%n%nThis generated password is for development use only. %nYour security configuration must be updated before running your application in production.%n", currentUser, currentPassword));
        }
        if (doReload) {
            AppConfig.reload();
        }
    }

    public static void parseCmdLineAndPrintBanner(String[] args) {
        Options options = new Options();
        Option help = Option.builder((String)"h").longOpt("help").desc("print this message").build();
        Option contextParam = Option.builder().longOpt("context_param").desc("To override a context parameter or a property --context_param  key=value").numberOfArgs(2).valueSeparator('=').build();
        Option context = Option.builder().longOpt("context").desc("To set the context name ").hasArg().build();
        Option stat = Option.builder().longOpt("stat_port").desc("To set statistic port number ").hasArg().build();
        Option pid = Option.builder().longOpt("pid").desc("To force pid of the job ").hasArg().build();
        Option configLoc = Option.builder().longOpt("config_location").desc("To set the configuration files to read, separated by ,").hasArgs().valueSeparator(',').build();
        Option configAdditionalLocLegacy = Option.builder().longOpt("spring.config.additional-location").desc("Alias for config_additional_location. To set the additional configuration files to read, separated by ,").hasArgs().valueSeparator(',').build();
        Option configAdditionalLoc = Option.builder().longOpt("config_additional_location").desc("To set the additional configuration files to read, separated by ,").hasArgs().valueSeparator(',').build();
        Option banner = Option.builder().longOpt("banner").desc("To set the location of the banner file").hasArg().build();
        options.addOption(help).addOption(contextParam).addOption(context).addOption(stat).addOption(pid).addOption(configLoc).addOption(configAdditionalLocLegacy).addOption(configAdditionalLoc).addOption(banner);
        DefaultParser parser = new DefaultParser();
        HelpFormatter helper = new HelpFormatter();
        try {
            String[] configFiles;
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption(help)) {
                helper.printHelp("Usage:", options);
                throw new RuntimeException("Exit");
            }
            if (cmd.hasOption(configLoc)) {
                configFiles = cmd.getOptionValues(configLoc);
                AppConfig.setConfigFileLocation(configFiles);
            }
            if (cmd.hasOption(configAdditionalLocLegacy)) {
                configFiles = cmd.getOptionValues(configAdditionalLocLegacy);
                AppConfig.addConfigFileLocation(configFiles);
            }
            if (cmd.hasOption(configAdditionalLoc)) {
                configFiles = cmd.getOptionValues(configAdditionalLoc);
                AppConfig.addConfigFileLocation(configFiles);
            }
            if (cmd.hasOption(context)) {
                System.setProperty("context", cmd.getOptionValue(context));
            }
            if (cmd.hasOption(contextParam)) {
                AppConfig.addContextParamProperty(cmd.getOptionValues(contextParam)[0], cmd.getOptionValues(contextParam)[1]);
            }
            if (cmd.hasOption(banner)) {
                System.setProperty("banner.location", cmd.getOptionValue(banner));
            }
            if (cmd.hasOption(pid)) {
                System.setProperty("pid", cmd.getOptionValue(pid));
            }
            if (cmd.hasOption(stat)) {
                System.setProperty("stat_port", cmd.getOptionValue(stat));
            }
            AppConfig.reload();
            AppJetty.printBanner();
        }
        catch (ParseException e) {
            helper.printHelp("Usage:", options);
            throw new RuntimeException(e);
        }
    }

    private static void printBanner() {
        String bannerFile = AppConfig.getInstance().getConfigs().getString("banner.location", "src/main/resources/config/banner.txt");
        Path bannerPath = null;
        if (bannerFile.startsWith("classpath:")) {
            try {
                URI uri = AppJetty.class.getResource(bannerFile.substring(10)).toURI();
                FileSystems.newFileSystem(uri, Collections.emptyMap());
                bannerPath = Paths.get(uri);
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Error while reading banner file ", (Object)e.getMessage());
                return;
            }
        } else {
            bannerPath = Paths.get(bannerFile, new String[0]);
        }
        if (Files.exists(bannerPath, new LinkOption[0])) {
            try {
                System.out.println(Files.readString(bannerPath));
            }
            catch (IOException e) {
                LOG.error("Error while reading banner file ", (Object)e.getMessage());
            }
        }
    }
}

