/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import app.utils.config.AppConfig;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.commons.configuration2.CompositeConfiguration;

public abstract class AppServlet
extends HttpServlet {
    private CamelContext camelContext;
    private Boolean useCamelContext;

    protected AppServlet(CamelContext camelContext) {
        this.setCamelContext(camelContext);
        this.setUseCamelContext(true);
    }

    protected AppServlet() {
        this.setUseCamelContext(false);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Boolean useCamelContext() {
        return this.useCamelContext;
    }

    public void setUseCamelContext(Boolean checkCamelContext) {
        this.useCamelContext = checkCamelContext;
    }

    public CompositeConfiguration cfg() {
        return AppConfig.getInstance().getConfigs();
    }

    protected void setHealthCheckResult(HttpServletResponse response, Collection<HealthCheck.Result> results) throws IOException {
        if (results.stream().anyMatch(it -> it.getState() != HealthCheck.State.UP)) {
            response.setStatus(500);
        } else {
            response.setStatus(200);
            response.getWriter().println("{\"status\":\"UP\"}");
        }
    }

    protected static void setHealthCheckResult(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().println("{\"status\":\"UP\"}");
    }
}

