/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import app.utils.server.AppServlet;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownServlet
extends AppServlet {
    private final Server server;
    private final JettyHTTPServerEngine serverEngine;
    private static Logger LOG = LoggerFactory.getLogger(ShutdownServlet.class);

    public ShutdownServlet(CamelContext context, JettyHTTPServerEngine serverEngine) {
        super(context);
        this.serverEngine = serverEngine;
        this.server = null;
    }

    public ShutdownServlet(Server server) {
        this.server = server;
        this.serverEngine = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted");
                Thread.interrupted();
            }
            if (this.getCamelContext() != null) {
                LOG.info("stopping camel routes");
                this.getCamelContext().shutdown();
            }
            if (this.serverEngine != null) {
                this.serverEngine.shutdown();
            }
        });
        service.submit(() -> {
            try {
                if (this.server != null) {
                    LOG.info("stopping jetty server");
                    this.server.stop();
                }
            }
            catch (Exception e) {
                LOG.error("Exception during shutdown", (Throwable)e);
            }
        });
        service.shutdown();
        response.setStatus(200);
    }
}

