/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server.management.info;

import app.utils.server.AppServlet;
import app.utils.server.management.info.EnvInfo;
import app.utils.server.management.info.JavaInfo;
import app.utils.server.management.info.OsInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.CamelContext;

public class InfoServlet
extends AppServlet {
    public InfoServlet() {
    }

    public InfoServlet(CamelContext camelContext) {
        super(camelContext);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        ObjectMapper objectMapper = new ObjectMapper();
        if (this.cfg().getBoolean("management.info.env.enabled", false)) {
            new EnvInfo().populateJson(json, this.cfg());
        }
        if (this.cfg().getBoolean("management.info.java.enabled", false)) {
            json.set("java", objectMapper.valueToTree((Object)new JavaInfo()));
        }
        if (this.cfg().getBoolean("management.info.os.enabled", false)) {
            json.set("os", objectMapper.valueToTree((Object)new OsInfo()));
        }
        if (super.useCamelContext().booleanValue() && super.getCamelContext() != null) {
            json.put("camel.name", super.getCamelContext().getName());
            json.put("camel.version", super.getCamelContext().getVersion());
            if (super.getCamelContext().getUptime() != null) {
                json.put("camel.uptime", super.getCamelContext().getUptime());
                json.put("camel.uptimeMillis", super.getCamelContext().getUptimeMillis());
            }
            json.put("camel.status", super.getCamelContext().getStatus().name());
        }
        String jsonResponse = objectMapper.writeValueAsString((Object)json);
        response.setContentType("application/json");
        response.setStatus(200);
        response.getWriter().write(jsonResponse);
    }
}

