/*
 * Decompiled with CFR 0.152.
 */
package app.utils.config;

import app.utils.config.ServerConfig;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfig {
    public static final String LIST_DELIMITER = ",";
    private static final Logger LOG = LoggerFactory.getLogger(AppConfig.class);
    private static AppConfig instance;
    private static List<String> sourceFileLocations;
    private static Properties contextParamsOverride;
    private static String SECURITY_USER_NAME_PROPERTY_NAME;
    private static String SECURITY_USER_NAME_DEFAULT_VALUE;
    private static String SECURITY_USER_PASSWORD_PROPERTY_NAME;
    private CompositeConfiguration configs = new CompositeConfiguration();

    private AppConfig() throws ConfigurationException {
        SystemConfiguration sysConfigs = new SystemConfiguration();
        EnvironmentConfiguration envConfigs = new EnvironmentConfiguration();
        PropertiesConfiguration propsConfigs = new PropertiesConfiguration();
        this.configs.addConfiguration((Configuration)sysConfigs);
        this.configs.addConfiguration((Configuration)envConfigs);
        if (sourceFileLocations != null) {
            sourceFileLocations.forEach(sourceFileLocation -> AppConfig.addConfigsFromFile(propsConfigs, sourceFileLocation));
            AppConfig.reloadValuesFromEnv(propsConfigs);
            AppConfig.validateSecurityConfig(propsConfigs);
            this.configs.addConfiguration((Configuration)propsConfigs);
        }
    }

    private static void reloadValuesFromEnv(PropertiesConfiguration propsConfigs) {
        HashMap<String, String> updProps = new HashMap<String, String>();
        Iterator keys = propsConfigs.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = propsConfigs.getString(key);
            if (value == null || !value.contains("${")) continue;
            Matcher m = Pattern.compile("\\$\\{([^:]*)\\:\\#\\{([^}]*)\\}\\}").matcher(value);
            while (m.find()) {
                String envValue = "null".equalsIgnoreCase(m.group(2)) ? "" : m.group(2);
                value = value.replace(m.group(0), new EnvironmentConfiguration().getString(m.group(1), envValue));
            }
            updProps.put(key, value);
        }
        for (Map.Entry p : updProps.entrySet()) {
            propsConfigs.setProperty((String)p.getKey(), p.getValue());
        }
    }

    public static void addConfigsFromFile(PropertiesConfiguration propsConfigs, String sourceFileLocation) {
        block12: {
            try {
                Path filePath = Path.of(sourceFileLocation, new String[0]);
                if (Files.exists(filePath, new LinkOption[0])) {
                    propsConfigs.read((Reader)new FileReader(filePath.toFile()));
                    break block12;
                }
                try (InputStream resourceAsStream = AppConfig.class.getClassLoader().getResourceAsStream(sourceFileLocation);){
                    if (resourceAsStream != null) {
                        Properties properties = new Properties();
                        properties.load(resourceAsStream);
                        for (String key : properties.stringPropertyNames()) {
                            String value = properties.getProperty(key);
                            propsConfigs.addProperty(key, (Object)value);
                        }
                    } else {
                        LOG.error("Failed to load file " + sourceFileLocation);
                    }
                }
            }
            catch (IOException | ConfigurationException e) {
                LOG.error("Failed to retrieve configs from file " + sourceFileLocation, e);
            }
        }
    }

    private static void validateSecurityConfig(PropertiesConfiguration config) {
        String springSecurityUserNameValue = config.getString(SECURITY_USER_NAME_PROPERTY_NAME);
        String springSecurityUserPasswordValue = config.getString(SECURITY_USER_PASSWORD_PROPERTY_NAME);
        if (springSecurityUserNameValue != null && !springSecurityUserNameValue.isEmpty() && springSecurityUserPasswordValue != null && !springSecurityUserPasswordValue.isEmpty()) {
            LOG.info("microservice security username and password are available");
        } else {
            LOG.warn("microservice security username and password are NOT available, generating");
            springSecurityUserNameValue = SECURITY_USER_NAME_DEFAULT_VALUE;
            springSecurityUserPasswordValue = UUID.randomUUID().toString();
            config.setProperty(SECURITY_USER_NAME_PROPERTY_NAME, (Object)springSecurityUserNameValue);
            config.setProperty(SECURITY_USER_PASSWORD_PROPERTY_NAME, (Object)springSecurityUserPasswordValue);
            LOG.warn(String.format("%n%nUsing generated security credentials %nusername: %s %npassword: %s%n%nThis generated password is for development use only. %nYour security configuration must be updated before running your application in production.%n", springSecurityUserNameValue, springSecurityUserPasswordValue));
        }
    }

    public static void setConfigFileLocation(String ... fileLocations) {
        if (fileLocations != null && fileLocations.length > 0) {
            sourceFileLocations = new ArrayList<String>();
            AppConfig.prioritizeAndAddFileLocations(fileLocations);
        } else {
            sourceFileLocations = null;
        }
    }

    public static void addConfigFileLocation(String ... fileLocations) {
        if (fileLocations != null && fileLocations.length > 0) {
            if (null == sourceFileLocations) {
                sourceFileLocations = new ArrayList<String>();
            }
            AppConfig.prioritizeAndAddFileLocations(fileLocations);
        }
    }

    private static void prioritizeAndAddFileLocations(String ... fileLocations) {
        for (String fileLocation : fileLocations) {
            sourceFileLocations.add(0, fileLocation);
        }
    }

    public static void addContextParamProperty(Object key, Object value) {
        contextParamsOverride.put(key, value);
    }

    public static Properties getContextParamsOverride() {
        return contextParamsOverride;
    }

    public static AppConfig getInstance() {
        if (instance == null) {
            try {
                instance = new AppConfig();
                ServerConfig.setSystemProperties();
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Failed to initialize AppConfig singleton instance", e);
            }
        }
        return instance;
    }

    public static void reload() {
        instance = null;
        AppConfig.getInstance();
    }

    public CompositeConfiguration getConfigs() {
        return this.configs;
    }

    public static CompositeConfiguration getCfg() {
        return AppConfig.getInstance().getConfigs();
    }

    public static int getInt(String name, int defaultValue) {
        try {
            return AppConfig.getCfg().getInt(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        try {
            return AppConfig.getCfg().getBoolean(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(String name) {
        return AppConfig.getCfg().getString(name);
    }

    public static String getString(String name, String defaultValue) {
        return AppConfig.getCfg().getString(name, defaultValue);
    }

    public static String getNonEmptyString(String name, String defaultValue) {
        String result = AppConfig.getCfg().getString(name, defaultValue);
        return result.length() == 0 ? defaultValue : result;
    }

    static {
        sourceFileLocations = new ArrayList<String>(Arrays.asList("config/application.properties"));
        contextParamsOverride = new Properties();
        SECURITY_USER_NAME_PROPERTY_NAME = "security.user.name";
        SECURITY_USER_NAME_DEFAULT_VALUE = "user";
        SECURITY_USER_PASSWORD_PROPERTY_NAME = "security.user.password";
    }
}

