/*
 * Decompiled with CFR 0.152.
 */
package app.utils.server;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class ManagementEndpointsHandler
extends HandlerWrapper {
    public static final List<String> MGMT_ALL_ENDPOINTS_PATH = List.of("jolokia", "prometheus", "health", "ready", "info", "shutdown");
    private final String mgmt;
    private final String middle;

    public ManagementEndpointsHandler(String mgmt) {
        this.mgmt = mgmt;
        this.middle = mgmt.endsWith("/") ? "" : "/";
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.shouldHandle(target)) {
            super.handle(target, baseRequest, request, response);
        }
    }

    private boolean shouldHandle(String target) {
        for (String endpointPath : MGMT_ALL_ENDPOINTS_PATH) {
            if (!target.startsWith(String.format("%s%s%s", this.mgmt, this.middle, endpointPath))) continue;
            return true;
        }
        return false;
    }
}

