/*
 * Decompiled with CFR 0.152.
 */
package app.utils.config;

import app.utils.config.AppConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;

public class ServerConfig {
    public static final String PROTOCOL_SYS_PROP_KEY = "microservice.server.protocol";
    public static final String HOST_SYS_PROP_KEY = "microservice.server.host";
    public static final String PORT_SYS_PROP_KEY = "microservice.server.port";
    public static final String SERVLET_CONTEXT_PATH_SYS_PROP_KEY = "microservice.server.servlet.context-path";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 8065;
    public static final String DEFAULT_SERVLET_CONTEXT_PATH = "/";
    public static final String MGMT_JOLOKIA_ENDPOINT = "jolokia";
    public static final String MGMT_PROMETHEUS_ENDPOINT = "prometheus";
    public static final String MGMT_HEALTH_ENDPOINT = "health";
    public static final String MGMT_CAMEL_HEALTH_ENDPOINT = "ready";
    public static final String MGMT_INFO_ENDPOINT = "info";
    public static final String MGMT_SHUTDOWN_ENDPOINT = "shutdown";
    public static final List<String> MGMT_ALL_ENDPOINTS = List.of("jolokia", "prometheus", "health", "info", "shutdown");
    public static final String DEFAULT_MGMT_BASE_PATH = "/";

    public static void setSystemProperties() {
        System.setProperty(PROTOCOL_SYS_PROP_KEY, ServerConfig.getProtocol());
        System.setProperty(HOST_SYS_PROP_KEY, ServerConfig.getHost());
        System.setProperty(PORT_SYS_PROP_KEY, Integer.toString(ServerConfig.getPort()));
        System.setProperty(SERVLET_CONTEXT_PATH_SYS_PROP_KEY, ServerConfig.getServletContextPath());
    }

    public static String getProtocol() {
        return AppConfig.getBoolean("security.require-ssl", false) ? "https" : AppConfig.getNonEmptyString("server.protocol", DEFAULT_PROTOCOL);
    }

    public static String getHost() {
        return AppConfig.getNonEmptyString("server.host", DEFAULT_HOST);
    }

    public static int getPort() {
        int result = AppConfig.getInt("server.port", -1);
        return result <= -1 ? 8065 : result;
    }

    public static String getAddress() {
        return String.format("%s://%s:%s", ServerConfig.getProtocol(), ServerConfig.getHost(), ServerConfig.getPort());
    }

    public static String getAddress(String endpointFromContextFile) throws URISyntaxException {
        return ServerConfig.getURI(endpointFromContextFile).toString();
    }

    public static URI getURI(String endpointFromContextFile) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(endpointFromContextFile);
        uriBuilder.setScheme(ServerConfig.getProtocol());
        uriBuilder.setHost(ServerConfig.getHost());
        uriBuilder.setPort(ServerConfig.getPort());
        return uriBuilder.build();
    }

    public static String getServletContextPath() {
        String result = AppConfig.getNonEmptyString("server.servlet.context-path", "/");
        return result.length() > 1 && result.endsWith("/") ? result.substring(0, result.length() - 1) : result;
    }

    public static String getMgmtContextPath() {
        String result = AppConfig.getNonEmptyString("management.server.base-path", "/");
        return result.length() > 1 && result.endsWith("/") ? result.substring(0, result.length() - 1) : result;
    }

    public static String getMgmtEndpointsPrefix() {
        String mgmtPath = ServerConfig.getMgmtContextPath();
        if (mgmtPath.endsWith("/")) {
            return String.format("%s%s", ServerConfig.getAddress(), mgmtPath);
        }
        return String.format("%s%s/", ServerConfig.getAddress(), mgmtPath);
    }

    public static List<String> getMgmtEndpointsToAdd() {
        String stringValue = AppConfig.getString("management.endpoints.web.exposure.include", null);
        if (null == stringValue) {
            return List.of(MGMT_HEALTH_ENDPOINT);
        }
        if ("".equals(stringValue = stringValue.replaceAll("\\s+", ""))) {
            return List.of();
        }
        HashSet<String> endopointsToAdd = new HashSet<String>();
        for (String endpoint : stringValue.split(",")) {
            if ("*".equals(endpoint)) {
                return MGMT_ALL_ENDPOINTS;
            }
            endopointsToAdd.add(endpoint.toLowerCase());
        }
        return List.copyOf(endopointsToAdd);
    }
}

