/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.server.legacy.oidc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(OidcAccessTokenFilter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, String>> HASH_MAP_TYPE_REF = new TypeReference<HashMap<String, String>>(){};
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private String validationEndpoint;

    public OidcAccessTokenFilter(String validationEndpoint) {
        if (validationEndpoint == null || validationEndpoint.isEmpty()) {
            throw new IllegalArgumentException("Location of Oidc validation endpoint is not set");
        }
        this.validationEndpoint = validationEndpoint;
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String accessToken;
        HttpServletRequest request = (HttpServletRequest)req;
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty() && this.verifyAccessToken(accessToken)) {
            chain.doFilter((ServletRequest)request, response);
            return;
        }
        HttpServletResponse httpResp = (HttpServletResponse)response;
        httpResp.setHeader("WWW-Authenticate", "Bearer");
        httpResp.sendError(401, "Unauthorized");
    }

    private boolean verifyAccessToken(String accessToken) throws IOException {
        boolean result = false;
        try {
            String postBody = String.format("token=%s&token_type_hint=access_token", URLEncoder.encode(accessToken, "UTF-8"));
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.validationEndpoint)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(postBody)).build();
            HttpResponse<InputStream> httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (httpResponse.statusCode() == 200) {
                Map map = (Map)OBJECT_MAPPER.readValue(httpResponse.body(), HASH_MAP_TYPE_REF);
                String active = (String)map.get("active");
                result = active != null && active.equalsIgnoreCase("true");
            }
        }
        catch (IOException e) {
            LOG.error("Something else than the token validity has gone wrong", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return result;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

